

<?php
require_once '../vendor/autoload.php';

use Transbank\Onepay\OnepayBase;
use Transbank\Onepay\Transaction;

session_start();

// Validar sesión
if (!isset($_SESSION['usuario'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

// ID de empresa desde sesión
$idEmp = $_SESSION['idEmp'] ?? 0;

// Función de ejemplo para traer credenciales de empresa
function obtenerCredencialesEmpresa($idEmp)
{
    return [
        'apiKey' => 'TU_API_KEY', // ← Reemplaza por las reales
        'secret' => 'TU_SHARED_SECRET',
        'env' => OnepayBase::INTEGRATION // o OnepayBase::PRODUCTION
    ];
}

$cred = obtenerCredencialesEmpresa($idEmp);

// Configurar Transbank Onepay
OnepayBase::setApiKey($cred['apiKey']);
OnepayBase::setSharedSecret($cred['secret']);
OnepayBase::setIntegrationType($cred['env']);

// Leer datos de la solicitud
$data = json_decode(file_get_contents("php://input"), true);
$occ = $data['occ'] ?? '';
$externalUniqueNumber = $data['externalUniqueNumber'] ?? '';

try {
    $respuesta = (new Transaction)->commit($occ, $externalUniqueNumber);

    if ($respuesta->getResponseCode() === "OK") {
        echo json_encode([
            'success' => true,
            'detalle' => $respuesta
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'mensaje' => 'Transacción no aprobada por Onepay'
        ]);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
