<?php
require_once '../vendor/autoload.php';

use Transbank\Onepay\OnepayBase;
use Transbank\Onepay\ShoppingCart;
use Transbank\Onepay\ShoppingCartItem;
use Transbank\Onepay\Transaction;

session_start();

// Asegurarse que el usuario está logueado
if (!isset($_SESSION['usuario'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

// ← ID de empresa desde sesión
$idEmp = $_SESSION['idEmp'] ?? 0;

// --- CONFIGURACIÓN POR EMPRESA ---
function obtenerCredencialesEmpresa($idEmp)
{
    // TODO: Aquí puedes consultar la BD para traer apiKey y secret por empresa
    return [
        'apiKey' => 'TU_API_KEY',         // Reemplaza con valor real o desde BD
        'secret' => 'TU_SHARED_SECRET',   // Reemplaza con valor real o desde BD
        'env' => OnepayBase::INTEGRATION  // O OnepayBase::PRODUCTION
    ];
}
$cred = obtenerCredencialesEmpresa($idEmp);

// Configurar Onepay SDK
OnepayBase::setApiKey($cred['apiKey']);
OnepayBase::setSharedSecret($cred['secret']);
OnepayBase::setIntegrationType($cred['env']);

// Leer JSON desde frontend
$data = json_decode(file_get_contents("php://input"), true);
$carrito = $data['carrito'] ?? [];
$total = $data['total'] ?? 0;

// Crear carrito para Onepay
$cart = new ShoppingCart();
foreach ($carrito as $item) {
    $cart->add(new ShoppingCartItem(
        $item['nombre'],
        $item['cantidad'],
        $item['precio']
    ));
}

try {
    $tx = (new Transaction)->create($cart);

    echo json_encode([
        'success' => true,
        'occ' => $tx->getOcc(),
        'ott' => $tx->getOtt(),
        'qrCodeAsBase64' => $tx->getQrCodeAsBase64(),
        'total' => $tx->getAmount(),
        'externalUniqueNumber' => $tx->getExternalUniqueNumber()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
