<?php
$carrito = null;

session_start();


// --- Protección contra manipulación del total enviado desde el cliente ---
require_once '../config/config.php'; // Asegúrate de tener la conexión a base de datos
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$carrito = json_decode($_POST['carrito'] ?? '[]', true);
$total = $_POST['total'] ?? 0;

$totalCalculado = 0;
if (is_array($carrito)) {
  foreach ($carrito as $item) {
    $idProducto = intval($item['id']);
    $cantidad = intval($item['cantidad']);

    // Consultar el precio real del producto en la base de datos
    $stmt = $conn->prepare("SELECT precio FROM productos WHERE id = ? AND activo = 1");
    $stmt->bind_param("i", $idProducto);
    $stmt->execute();
    $stmt->bind_result($precioBD);
    $stmt->fetch();
    $stmt->close();

    // Si no se encuentra el producto o el precio, cancelamos
    if (!$precioBD || $cantidad <= 0) {
      die("Producto inválido en el carrito.");
    }

    $totalCalculado += $precioBD * $cantidad;
  }
}

// Comparar total calculado con el recibido (permitiendo un margen de diferencia por delivery o descuentos)
$margen = 5000; // puedes ajustarlo según tu sistema
if (abs($total - $totalCalculado) > $margen) {
  die("El total enviado no coincide con los precios reales. Intenta nuevamente.");
}
// --- Fin protección ---
?>

<!DOCTYPE html>
<html lang="es">

<head>
  <meta charset="UTF-8">
  <title>Checkout - Empanadas</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: url('../images/fondoDDS.png') no-repeat center center fixed;
      background-size: cover;
      margin: 0;
      padding: 1rem;
    }

    .container {
      max-width: 600px;
      margin: 2rem auto;
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(6px);
      border-radius: 20px;
      padding: 1.5rem;
      box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
    }

    h2 {
      color: #ff6f00;
      margin-bottom: 1rem;
    }

    .producto {
      display: flex;
      justify-content: space-between;
      margin-bottom: 0.8rem;
      border-bottom: 1px solid #eee;
      padding-bottom: 0.5rem;
    }

    .total {
      font-size: 1.3rem;
      font-weight: bold;
      text-align: right;
      margin: 1.5rem 0;
    }

    input {
      width: 93%;
      padding: 12px;
      margin-bottom: 1rem;
      border: 1px solid #ccc;
      border-radius: 12px;
    }

    button {
      background: #ff6f00;
      color: white;
      border: none;
      padding: 14px;
      font-size: 1rem;
      border-radius: 12px;
      width: 100%;
      cursor: pointer;
      transition: all 0.3s ease-in-out;
    }

    button:hover {
      background: #e65100;
    }

    .back {
      display: inline-block;
      margin-bottom: 1rem;
      color: #999;
      text-decoration: none;
      font-size: 0.9rem;
    }
  </style>
</head>

<body>

  <div style="position: fixed; inset: 0; background: rgba(0,0,0,0.15); z-index: -1;"></div>

  <div class="container">
    <a href="javascript:void(0)" onclick="window.history.back()" class="back">← Volver a productos</a>

    <h2>Resumen del Pedido</h2>
    <?php if (!empty($carrito)): ?>
      <?php foreach ($carrito as $item): ?>
        <div class="producto">
          <div>
            <?php
            $idProducto = intval($item['id']);
            $stmt = $conn->prepare("SELECT Apedido, hrs_produccion FROM productos WHERE id = ?");
            $stmt->bind_param("i", $idProducto);
            $stmt->execute();
            $stmt->bind_result($esPedido, $hrsProduccion);
            $stmt->fetch();
            $stmt->close();

            $etiqueta = htmlspecialchars($item['nombre']);
            if ($esPedido == 1 && !empty($hrsProduccion)) {
              $etiqueta .= " (" . $hrsProduccion . " hrs)";
            }
            echo $item['cantidad'] . 'x ' . $etiqueta;
            if ($esPedido == 1 && is_numeric($hrsProduccion)) {
              $fechaEntrega = new DateTime();
              $fechaEntrega->modify("+$hrsProduccion hours");
              echo '<div style="color: #ff6f00; font-size: 0.85rem;">Entrega estimada: ' . $fechaEntrega->format('d/m H:i') . '</div>';
            }
            ?>
          </div>
          <div style="display: flex; align-items: center; gap: 6px;">
            $<?php echo number_format($item['precio'] * $item['cantidad'], 0, ',', '.'); ?>
            <button type="button" onclick="eliminarDelCarrito(<?php echo $item['id']; ?>)" style="background:none;border:none;color:red;font-weight:bold;cursor:pointer;">✖</button>
          </div>
        </div>

</html>
<script>
  function eliminarDelCarrito(idProducto) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'checkout.php';

    const nuevoCarrito = <?php echo json_encode($carrito); ?>.filter(item => item.id != idProducto);
    const inputCarrito = document.createElement('input');
    inputCarrito.type = 'hidden';
    inputCarrito.name = 'carrito';
    inputCarrito.value = JSON.stringify(nuevoCarrito);

    const inputTotal = document.createElement('input');
    inputTotal.type = 'hidden';
    inputTotal.name = 'total';
    inputTotal.value = nuevoCarrito.reduce((acc, item) => acc + (item.precio * item.cantidad), 0);

    form.appendChild(inputCarrito);
    form.appendChild(inputTotal);
    document.body.appendChild(form);
    form.submit();
  }
</script>
<?php endforeach; ?>
<div class="total" id="total-original">Total: <span style="text-decoration: none;" id="total-texto">$<?php echo number_format($total, 0, ',', '.'); ?></span></div>
<div class="total" id="detalle-descuento" style="display:none; font-size: 1rem; color: #4caf50; text-align: right;"></div>
<div class="total" id="detalle-delivery" style="display:none; font-size: 1rem; color: #1976d2; text-align: right;"></div>
<div class="total" id="nuevo-total" style="display:none;"></div>
<?php else: ?>
  <p>No hay productos en el carrito.</p>
<?php endif; ?>

<hr style="margin: 2rem 0; border: 0; border-top: 1px solid #ddd;">

<h2 style="color: #ff6f00;">Código de Descuento</h2>
<div style="display: flex; gap: 10px; align-items: center; margin-bottom: 1rem;">
  <input type="text" name="codigo_descuento" placeholder="Código de Descuento" form="formulario-pedido"
    style="width: 60%; margin-bottom: 0; padding: 10px; border-radius: 12px; border: 1px solid #ccc;">
  <button type="button" onclick="validarDescuento()"
    style="width: 40%; padding: 10px; font-size: 0.9rem; color: #ff6f00; background: none; border: 1px solid #ff6f00; border-radius: 12px; cursor: pointer; transition: all 0.3s ease-in-out;">
    Aplicar
  </button>
</div>

<div id="mensaje-descuento" style="font-size: 0.9rem;"></div>
<div class="total" id="total-con-descuento" style="display:none;"></div>


<hr style="margin: 2rem 0; border: 0; border-top: 1px solid #ddd;">

<h2>Datos del Cliente</h2>
<form action="guardar_pedido.php" method="POST" id="formulario-pedido">
  <input type="hidden" name="descuento_aplicado" value="0">

  <input type="hidden" name="json" value='<?php echo json_encode($carrito); ?>'>
  <input type="hidden" name="total" value="<?php echo $total; ?>">

  <input type="text" name="nombre" placeholder="Nombre" required oninput="verificarFormulario()">
  <input type="email" name="email" placeholder="Correo electrónico" required oninput="verificarFormulario()">
  <!--<input type="tel" name="telefono" placeholder="Teléfono 9 8765 6542"  style="width: 93%; padding: 12px; margin-bottom: 1rem; border: 1px solid #ccc; border-radius: 8px;">-->

  <input type="tel"
    name="telefono"
    id="telefono"
    placeholder="Ej: 912345678"
    maxlength="9"
    pattern="[0-9]{9}"
    style="width: 93%; padding: 12px; margin-bottom: 1rem; border: 1px solid #ccc; border-radius: 12px;"
    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,9)">
  <div id="delivery-extra-fields" style="display: none;">
    <input id="autocomplete-direccion" name="direccion" type="text" placeholder="Dirección (Ej: Av. Siempre Viva 742)" style="width: 93%; padding: 12px; margin-bottom: 1rem; border: 1px solid #ccc; border-radius: 12px;">
    <input type="text" name="comentarioDireccion" placeholder="Referencia adicional (Ej: Depto 731, entrepasaje)" style="width: 93%; padding: 12px; margin-bottom: 1rem; border: 1px solid #ccc; border-radius: 12px;">

  </div>
  <!--<p style="font-size: 0.9rem; color: #666;">A este correo electrónico enviaremos las notificaciones.</p>-->

  <div style="display: flex; gap: 10px; margin: 1rem 0;">
    <button type="button" onclick="solicitarFechaHora('delivery', '¿Para cuándo y a qué hora quieres que dejemos tu pedido?')" style="flex: 1; background: #2196f3; border-radius: 12px; transition: all 0.3s ease-in-out;">🚚 Delivery</button>
    <button type="button" onclick="solicitarFechaHora('retiro', '¿Para cuándo quieres que tengamos listo tu pedido para retiro?')" style="flex: 1; background: #4caf50; border-radius: 12px; transition: all 0.3s ease-in-out;">🏪 Retiro en tienda</button>
  </div>

  <input type="hidden" name="comuna">
  <input type="hidden" name="numero">
  <input type="hidden" name="delivery_monto">
  <input type="hidden" name="distancia_km">

  <div id="info-pago" style="margin-top: 1rem;"></div>
  <button type="submit" style="display:none;" id="boton-confirmar">✅ Confirmar Pedido</button>

  <?php
  if (session_status() === PHP_SESSION_NONE) session_start();
  if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
  }
  ?>
  <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

  <input type="hidden" name="negocio_id" value="<?php echo $carrito[0]['negocio_id'] ?? 1; ?>">

</form>
</div>
<!--<div id="mapa" style="height: 300px; margin-top: 2rem;"></div>-->
<p id="info-delivery" style="font-size: 0.9rem; color: #333; display: none;"></p>

<script>
  const negocioLatLng = {
    lat: -33.46131,
    lng: -70.60404
  }; // ← Cambia por tu ubicación
  let deliveryCosto = 0;

  function initMapDelivery() {
    const map = new google.maps.Map(document.getElementById("mapa"), {
      zoom: 13,
      center: negocioLatLng
    });

    // Llamar autocompletado
    initAutocomplete();

    new google.maps.Marker({
      position: negocioLatLng,
      map,
      label: "📍",
      title: "Tu negocio"
    });

    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition((pos) => {
        const clienteLatLng = {
          lat: -33.5, // <- Coordenadas de prueba (cambia por tu ciudad)
          lng: -70.6
        };

        new google.maps.Marker({
          position: clienteLatLng,
          map,
          icon: "http://maps.google.com/mapfiles/ms/icons/blue-dot.png",
          title: "Tu ubicación"
        });

        calcularDelivery(clienteLatLng.lat, clienteLatLng.lng);
      }, () => {
        document.getElementById('info-delivery').textContent = "No se pudo obtener tu ubicación para calcular el delivery.";
        document.getElementById('info-delivery').style.display = 'block';
      });
    }
  }

  function calcularDelivery(latCliente, lngCliente) {
    const service = new google.maps.DistanceMatrixService();
    service.getDistanceMatrix({
      origins: [negocioLatLng],
      destinations: [{
        lat: latCliente,
        lng: lngCliente
      }],
      travelMode: google.maps.TravelMode.DRIVING,
      unitSystem: google.maps.UnitSystem.METRIC
    }, function(response, status) {
      if (status === 'OK') {
        const distanciaTexto = response.rows[0].elements[0].distance.text;
        const distanciaKm = response.rows[0].elements[0].distance.value / 1000;

        const boton = document.querySelector('button[type="submit"]');
        const totalInput = document.querySelector('input[name="total"]');
        const totalOriginal = <?php echo $total; ?>;
        const inputDescuento = document.querySelector('input[name="descuento_aplicado"]').value;
        const totalDescuento = parseInt(inputDescuento || 0);

        if (distanciaKm > 10) {
          fueraDeZona = true;
          boton.disabled = true;
          alert("La dirección está fuera de nuestra zona de despacho (10 km). Puedes seleccionar retiro en tienda.");
          document.getElementById('info-delivery').textContent = 'Fuera de zona de despacho.';
          document.getElementById('info-delivery').style.display = 'block';
          return;
        }

        fueraDeZona = false;
        deliveryCosto = Math.ceil(distanciaKm * 500);
        document.querySelector('input[name="delivery_monto"]').value = deliveryCosto;
        document.querySelector('input[name="distancia_km"]').value = distanciaKm.toFixed(2);
        let detalleDelivery = document.getElementById('detalle-delivery');
        if (!detalleDelivery) {
          detalleDelivery = document.createElement('div');
          detalleDelivery.id = 'detalle-delivery';
          detalleDelivery.className = 'total';
          document.getElementById('nuevo-total').insertAdjacentElement('beforebegin', detalleDelivery);
        }
        detalleDelivery.textContent = `Costo delivery: $${deliveryCosto.toLocaleString('es-CL')}`;
        detalleDelivery.style.display = 'block';
        const totalFinal = totalOriginal - totalDescuento + deliveryCosto;

        document.getElementById('total-texto').style.textDecoration = 'line-through';
        document.getElementById('info-delivery').textContent =
          `Distancia: ${distanciaTexto} | Costo de delivery: $${deliveryCosto.toLocaleString('es-CL')}`;
        document.getElementById('info-delivery').style.display = 'block';
        document.getElementById('nuevo-total').style.display = 'block';
        document.getElementById('nuevo-total').textContent =
          `Total a pagar: $${totalFinal.toLocaleString('es-CL')}`;

        totalInput.value = totalFinal;
        boton.disabled = false;
      }
    });
  }

  function elegirDelivery() {
    document.getElementById('delivery-extra-fields').style.display = 'block';
    document.getElementById('boton-confirmar').style.display = 'none';
    document.getElementById('info-delivery').textContent = 'Ingresa tu dirección y presiona "📍 Usar mi ubicación actual" o completa manualmente.';
    document.getElementById('info-delivery').style.display = 'block';

    if (!document.getElementById('btn-calcular-delivery')) {
      const deliveryFields = document.getElementById('delivery-extra-fields');

      const calcularBtn = document.createElement('button');
      calcularBtn.id = 'btn-calcular-delivery';
      calcularBtn.type = 'button';
      calcularBtn.textContent = '🚗 Calcular costo de delivery';
      calcularBtn.style.cssText = 'width: 100%; padding: 12px; margin-bottom: 1rem; background: #2196f3; color: white; border: none; border-radius: 8px;';
      calcularBtn.onclick = () => {
        const direccion = document.getElementById('autocomplete-direccion').value;
        if (!direccion || direccion.length < 5) {
          alert('Por favor escribe una dirección válida');
          return;
        }

        const geocoder = new google.maps.Geocoder();
        geocoder.geocode({
          address: direccion
        }, function(results, status) {
          if (status === 'OK') {
            const ubicacion = results[0].geometry.location;
            calcularDelivery(ubicacion.lat(), ubicacion.lng());
            document.getElementById('boton-confirmar').style.display = 'block';
          } else {
            document.getElementById('info-delivery').textContent = 'No se pudo calcular el delivery con esa dirección.';
          }
        });
      };

      deliveryFields.appendChild(calcularBtn);
    }
  }

  function elegirRetiro() {
    document.getElementById('info-delivery').textContent = 'Seleccionado: Retiro en tienda (sin costo)';
    document.getElementById('info-delivery').style.display = 'block';
    document.getElementById('nuevo-total').style.display = 'block';
    document.getElementById('nuevo-total').textContent = 'Total final: $' + totalOriginal.toLocaleString('es-CL');
    document.querySelector('input[name="total"]').value = totalOriginal;

    document.querySelector('input[name="direccion"]').value = '';
    document.querySelector('input[name="delivery_monto"]').value = '';
    document.querySelector('input[name="distancia_km"]').value = '';
    document.getElementById('delivery-extra-fields').style.display = 'none';
    document.getElementById('detalle-delivery').style.display = 'none';
    document.getElementById('detalle-descuento').style.display = 'none';
    document.getElementById('total-texto').style.textDecoration = 'none';

    document.getElementById('boton-confirmar').style.display = 'block';
    document.getElementById('nuevo-total').textContent = 'Total a pagar: $' + totalOriginal.toLocaleString('es-CL');
  }

  function geolocalizarDireccion() {
    const comuna = document.getElementById('comuna').value;
    const calle = document.getElementById('calle').value;
    const numero = document.getElementById('numero').value;
    const direccionCompleta = `${calle} ${numero}, ${comuna}, Chile`;
    document.getElementById('direccion').value = direccionCompleta;

    const geocoder = new google.maps.Geocoder();
    geocoder.geocode({
      address: direccionCompleta
    }, function(results, status) {
      if (status === 'OK') {
        const ubicacion = results[0].geometry.location;
        calcularDelivery(ubicacion.lat(), ubicacion.lng());
        document.getElementById('boton-confirmar').style.display = 'block';
      } else {
        document.getElementById('info-delivery').textContent = 'No se pudo calcular delivery. Se asumirá retiro en tienda.';
        document.getElementById('info-delivery').style.display = 'block';
        document.getElementById('boton-confirmar').style.display = 'block';
      }
    });
  }

  function verificarFormulario() {
    const nombre = document.querySelector('input[name="nombre"]').value;
    const telefono = document.querySelector('input[name="email"]').value;
    const botonDelivery = document.getElementById('boton-calcular-delivery');

    if (nombre && telefono) {
      botonDelivery.style.display = 'block';
    } else {
      botonDelivery.style.display = 'none';
      document.getElementById('boton-confirmar').style.display = 'none';
    }
  }

  function autocompletarUbicacion() {
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition((position) => {
        const lat = position.coords.latitude;
        const lng = position.coords.longitude;

        const geocoder = new google.maps.Geocoder();
        const latlng = {
          lat,
          lng
        };
        geocoder.geocode({
          location: latlng
        }, (results, status) => {
          if (status === 'OK' && results[0]) {
            const direccionPartes = results[0].address_components;
            let comunaAuto = '',
              calleAuto = '',
              numeroAuto = '';
            direccionPartes.forEach(part => {
              if (part.types.includes('route')) calleAuto = part.long_name;
              if (part.types.includes('street_number')) numeroAuto = part.long_name;
              if (part.types.includes('locality')) comunaAuto = part.long_name;
            });

            document.getElementById('swal-comuna').value = comunaAuto;
            document.getElementById('swal-calle').value = calleAuto;
            document.getElementById('swal-numero').value = numeroAuto;
          }
        });
      });
    } else {
      alert('Geolocalización no soportada por tu navegador.');
    }

    function mostrarInfoPago(metodo) {
      const infoDiv = document.getElementById('info-pago');
      if (metodo === 'transferencia') {
        infoDiv.innerHTML = `
        <table style="width: 100%; font-size: 0.9rem; border: 1px solid #ddd; border-collapse: collapse; margin-top: 1rem;">
          <tr><td style="border: 1px solid #ddd; padding: 6px;">Banco</td><td style="border: 1px solid #ddd; padding: 6px;">Banco Estado</td></tr>
          <tr><td style="border: 1px solid #ddd; padding: 6px;">Tipo</td><td style="border: 1px solid #ddd; padding: 6px;">Cuenta Rut</td></tr>
          <tr><td style="border: 1px solid #ddd; padding: 6px;">N° Cuenta</td><td style="border: 1px solid #ddd; padding: 6px;">12345678</td></tr>
          <tr><td style="border: 1px solid #ddd; padding: 6px;">Nombre</td><td style="border: 1px solid #ddd; padding: 6px;">Juan Pérez</td></tr>
          <tr><td style="border: 1px solid #ddd; padding: 6px;">RUT</td><td style="border: 1px solid #ddd; padding: 6px;">12.345.678-9</td></tr>
        </table>
        <p style="margin-top: 0.5rem;">Una vez realizada la transferencia, presiona "Confirmar Pedido".</p>
      `;
      } else if (metodo === 'mercadopago') {
        infoDiv.innerHTML = `
        <p style="margin-top: 0.5rem;">Serás redirigido a Mercado Pago al confirmar el pedido.</p>
      `;
      } else {
        infoDiv.innerHTML = `<p style="margin-top: 0.5rem;">Puedes pagar en efectivo al momento de retirar o recibir tu pedido.</p>`;
      }
    }

  }
</script>

<!--<script async defer
  src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCdjmUrKZlIvOOdPvPMswE4azwBfxNd_X4&callback=initMapDelivery">
  
</script>-->
<!--<script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCdjmUrKZlIvOOdPvPMswE4azwBfxNd_X4&libraries=places"></script>-->
<script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCdjmUrKZlIvOOdPvPMswE4azwBfxNd_X4&libraries=places&callback=initAutocompleteDireccion"></script>
<script>
  const totalOriginal = <?php echo $total; ?>;

  function validarDescuento() {
    const codigo = document.querySelector('input[name="codigo_descuento"]').value;
    if (!codigo) return;

    fetch('validar_descuento.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        },
        body: 'codigo=' + encodeURIComponent(codigo)
      })
      .then(res => res.json())
      .then(data => {
        const mensaje = document.getElementById('mensaje-descuento');
        const totalTexto = document.getElementById('total-texto');
        const totalOriginalDiv = document.getElementById('total-original');
        const detalleDescuento = document.getElementById('detalle-descuento');
        const nuevoTotalDiv = document.getElementById('nuevo-total');
        const inputTotal = document.querySelector('input[name="total"]');
        const inputDescuento = document.querySelector('input[name="descuento_aplicado"]');

        if (data.valido) {
          let descuentoAplicado = 0;
          let deliveryCostoActual = deliveryCosto || 0;
          let nuevoTotal = totalOriginal + deliveryCostoActual;

          if (data.descuento_porcentaje > 0) {
            descuentoAplicado = totalOriginal * data.descuento_porcentaje / 100;
            nuevoTotal -= descuentoAplicado;
          } else if (data.descuento_monto > 0) {
            descuentoAplicado = data.descuento_monto;
            nuevoTotal -= descuentoAplicado;
          }

          nuevoTotal = Math.max(0, nuevoTotal);

          // Mostrar visualmente
          totalTexto.style.textDecoration = 'line-through';
          detalleDescuento.style.display = 'block';
          detalleDescuento.textContent = 'Descuento aplicado: -$' + Math.round(descuentoAplicado).toLocaleString('es-CL');
          nuevoTotalDiv.style.display = 'block';
          nuevoTotalDiv.textContent = 'Total a pagar: $' + Math.round(nuevoTotal).toLocaleString('es-CL');

          // Actualizar valores ocultos para el backend
          inputTotal.value = Math.round(nuevoTotal);
          inputDescuento.value = Math.round(descuentoAplicado);

          mensaje.textContent = '¡Código válido! Descuento aplicado.';
          mensaje.style.color = 'green';

        } else {
          mensaje.textContent = 'Código inválido o expirado.';
          mensaje.style.color = 'red';
          totalTexto.style.textDecoration = 'none';
          detalleDescuento.style.display = 'none';
          nuevoTotalDiv.style.display = 'none';
          inputDescuento.value = 0; // Resetear
        }
      })
      .catch(() => {
        document.getElementById('mensaje-descuento').textContent = 'Error al validar el código.';
      });
  }
</script>

<script>
  let autocomplete;

  function initAutocomplete() {
    const input = document.getElementById('calle');
    autocomplete = new google.maps.places.Autocomplete(input, {
      types: ['geocode'],
      componentRestrictions: {
        country: 'cl'
      } // Chile, puedes cambiarlo
    });

    autocomplete.addListener('place_changed', function() {
      const place = autocomplete.getPlace();
      if (!place.geometry) {
        document.getElementById('info-delivery').textContent = 'No se pudo localizar esa dirección.';
        document.getElementById('info-delivery').style.display = 'block';
        return;
      }

      const location = place.geometry.location;
      calcularDelivery(location.lat(), location.lng());
    });
  }
</script>
<script>
  function initAutocompleteDireccion() {
    const input = document.getElementById("autocomplete-direccion");
    if (input) {
      const autocomplete = new google.maps.places.Autocomplete(input, {
        types: ['address'],
        componentRestrictions: {
          country: 'cl'
        }
      });

      autocomplete.addListener("place_changed", () => {
        const place = autocomplete.getPlace();
        // Opcionalmente, puedes extraer comuna, número, etc.
      });
    }
  }

  // Ejecutar después de cargar la API de Google Maps
  //  google.maps.event.addDomListener(window, 'load', initAutocompleteDireccion);
</script>
<?php
$fechaMaxEntrega = new DateTime();
foreach ($carrito as $item) {
  $idProducto = intval($item['id']);
  $stmt = $conn->prepare("SELECT Apedido, hrs_produccion FROM productos WHERE id = ?");
  $stmt->bind_param("i", $idProducto);
  $stmt->execute();
  $stmt->bind_result($esPedido, $hrs);
  $stmt->fetch();
  $stmt->close();

  if ($esPedido == 1 && is_numeric($hrs)) {
    $posible = new DateTime();
    $posible->modify("+$hrs hours");
    if ($posible > $fechaMaxEntrega) {
      $fechaMaxEntrega = $posible;
    }
  }
}
$fechaEntregaLimite = $fechaMaxEntrega->format('Y-m-d\TH:i');
?>
<script>
  function solicitarFechaHora(tipo, msje) {
    const minDateTime = "<?php echo $fechaEntregaLimite; ?>";
    const productoConRetraso = <?php
                                // Nueva lógica: contar cuántos productos a pedido hay y usar el hrs_produccion más alto para minDateTime
                                $productosAPedido = [];
                                $mayorHoras = 0;
                                foreach ($carrito as $item) {
                                  $idProducto = intval($item['id']);
                                  $stmt = $conn->prepare("SELECT Apedido, hrs_produccion, nombre FROM productos WHERE id = ?");
                                  $stmt->bind_param("i", $idProducto);
                                  $stmt->execute();
                                  $stmt->bind_result($esPedido, $hrs, $nombre);
                                  $stmt->fetch();
                                  $stmt->close();
                                  if ($esPedido == 1 && is_numeric($hrs)) {
                                    $productosAPedido[] = $nombre;
                                    if ($hrs > $mayorHoras) {
                                      $mayorHoras = $hrs;
                                    }
                                  }
                                }
                                $mensajePedido = '';
                                $cantidad = count($productosAPedido);
                                if ($cantidad == 1) {
                                  $mensajePedido = $productosAPedido[0];
                                } elseif ($cantidad > 1) {
                                  $mensajePedido = "$cantidad productos a pedido";
                                }
                                echo json_encode($mensajePedido);
                                ?>;

    // Si hay producto a pedido válido (con nombre), mostrar el mensaje y el botón eliminar.
    if (productoConRetraso && productoConRetraso.trim() !== "") {
      Swal.fire({
        title: `${msje}`,
        html: `
          <p style="font-size: 0.9rem; color: #ff6f00;">
            Nota: "${productoConRetraso}" ${productoConRetraso.includes('producto') ? 'es un producto a pedido' : 'son productos a pedido'} y requieren más tiempo de preparación.<br>
            Puedes quitarlo para acelerar la entrega.
          </p>
          <input type="datetime-local" id="fechaHoraSeleccionada" class="swal2-input" min="${minDateTime}" value="${minDateTime}">
        `,
        showCancelButton: true,
        cancelButtonText: '❌ Eliminar producto',
        confirmButtonText: 'Confirmar',
        preConfirm: () => {
          const valor = document.getElementById('fechaHoraSeleccionada').value;
          if (!valor || valor < minDateTime) {
            Swal.showValidationMessage('Debes elegir una fecha y hora igual o posterior a la estimada.');
            return false;
          }
          return valor;
        }
      }).then((result) => {
        if (result.isConfirmed) {
          const campo = document.createElement('input');
          campo.type = 'hidden';
          campo.name = 'fecha_hora_entrega';
          campo.value = result.value;
          document.getElementById('formulario-pedido').appendChild(campo);

          if (tipo === 'delivery') {
            elegirDelivery();
          } else {
            elegirRetiro();
          }
        } else if (result.dismiss === Swal.DismissReason.cancel) {
          eliminarProductoPorNombre(productoConRetraso);
        }
      });
    } else {
      // Si NO hay producto a pedido, eliminar mensaje y botón eliminar.
      Swal.fire({
        title: `${msje}`,
        html: `
          <input type="datetime-local" id="fechaHoraSeleccionada" class="swal2-input" min="${minDateTime}" value="${minDateTime}">
        `,
        showCancelButton: false,
        confirmButtonText: 'Confirmar',
        preConfirm: () => {
          const valor = document.getElementById('fechaHoraSeleccionada').value;
          if (!valor || valor < minDateTime) {
            Swal.showValidationMessage('Debes elegir una fecha y hora igual o posterior a la estimada.');
            return false;
          }
          return valor;
        }
      }).then((result) => {
        if (result.isConfirmed) {
          const campo = document.createElement('input');
          campo.type = 'hidden';
          campo.name = 'fecha_hora_entrega';
          campo.value = result.value;
          document.getElementById('formulario-pedido').appendChild(campo);

          if (tipo === 'delivery') {
            elegirDelivery();
          } else {
            elegirRetiro();
          }
        }
        // No hay botón cancelar, así que no hay else if para dismiss === cancel
      });
    }
  }

  function eliminarProductoPorNombre(nombre) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'checkout.php';

    const nuevoCarrito = <?php echo json_encode($carrito); ?>.filter(item => item.nombre !== nombre);
    const inputCarrito = document.createElement('input');
    inputCarrito.type = 'hidden';
    inputCarrito.name = 'carrito';
    inputCarrito.value = JSON.stringify(nuevoCarrito);

    const inputTotal = document.createElement('input');
    inputTotal.type = 'hidden';
    inputTotal.name = 'total';
    inputTotal.value = nuevoCarrito.reduce((acc, item) => acc + (item.precio * item.cantidad), 0);

    form.appendChild(inputCarrito);
    form.appendChild(inputTotal);
    document.body.appendChild(form);
    form.submit();
  }
</script>
<!-- Botón para iniciar pago con Onepay -->
<!--<button id="btn-onepay" class="btn btn-primary" style="width:100%; margin-top: 20px;" onclick="iniciarPagoOnepay()">Pagar con Onepay</button>-->

<!-- Contenedor para mostrar QR de Onepay -->
<div id="qrOnepayContainer" style="display:none; text-align:center; margin-top:20px;">
  <h4>Escanea el código QR con tu app Onepay</h4>
  <img id="qrOnepay" src="" style="max-width: 220px;" />
  <button class="btn btn-success mt-3" onclick="confirmarPagoOnepay()">Ya pagué</button>
</div>

<script>
  function iniciarPagoOnepay() {
    const carrito = <?php echo json_encode($carrito); ?>;
    const total = <?php echo $total; ?>;

    fetch('IniciarPagoOnepay.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          carrito,
          total
        })
      })
      .then(res => res.json())
      .then(data => {
        if (data.success) {
          document.getElementById('qrOnepay').src = 'data:image/png;base64,' + data.qrCodeAsBase64;
          document.getElementById('qrOnepayContainer').style.display = 'block';
          window.datosPagoOnepay = {
            occ: data.occ,
            externalUniqueNumber: data.externalUniqueNumber
          };
        } else {
          Swal.fire("Error", data.error || "No se pudo generar el QR", "error");
        }
      });
  }

  function confirmarPagoOnepay() {
    const datos = window.datosPagoOnepay;
    if (!datos) return;

    fetch('ConfirmarPagoOnepay.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(datos)
      })
      .then(res => res.json())
      .then(data => {
        if (data.success) {
          Swal.fire("✅ Pago confirmado", "Tu pedido ha sido recibido con éxito", "success")
            .then(() => {
              document.getElementById('formulario-pedido').submit();
            });
        } else {
          Swal.fire("Pago no confirmado", data.mensaje || "Intenta nuevamente", "warning");
        }
      });
  }
</script>
</body>

</html>