<?php
session_start();
require_once '../config/config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$negocio_id = $_SESSION['negocio_id'] ?? 0;

if ($negocio_id == 0) {
  die("❌ No tienes permisos para exportar productos.");
}

// Cabeceras para descargar CSV
header("Content-Type: text/csv; charset=utf-8");
header("Content-Disposition: attachment; filename=productos.csv");

// Abrir el output
$output = fopen('php://output', 'w');

// Encabezados del CSV (mismos nombres de columnas que en la tabla para facilitar importación)
fputcsv($output, [
  'id',
  'negocio_id',
  'nombre',
  'descripcion',
  'imagen_url',
  'precio',
  'stock',
  'categoria',
  'activo',
  'categoria1',
  'categoria2',
  'categoria3'
]);

// Consulta de productos
$query = "SELECT id, negocio_id, nombre, descripcion, imagen_url, precio, stock, categoria, activo, categoria1, categoria2, categoria3 FROM productos WHERE negocio_id = $negocio_id";
$result = $conn->query($query);

if ($result && $result->num_rows > 0) {
  while ($row = $result->fetch_assoc()) {
    // Escribir fila en CSV
    fputcsv($output, [
      $row['id'],
      $row['negocio_id'],
      $row['nombre'],
      $row['descripcion'],
      $row['imagen_url'],
      $row['precio'],
      $row['stock'],
      $row['categoria'],
      $row['activo'],
      $row['categoria1'],
      $row['categoria2'],
      $row['categoria3']
    ]);
  }
} else {
  // Puedes comentar esta línea si no quieres escribir nada en caso de tabla vacía
  fputcsv($output, ['No hay productos registrados.']);
}

fclose($output);
exit;
