<?php
session_start();
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
  http_response_code(403);
  echo json_encode(['status' => 'error', 'message' => 'CSRF token inválido']);
  exit;
}
require_once '../config/config.php';
require_once '../mailer/deliciasdulcesysaladas.php';

header('Content-Type: application/json');

require '/var/www/html/vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Conexión
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
  http_response_code(500);
  echo json_encode(['status' => 'error', 'message' => 'Error de conexión']);
  exit;
}

// Detectar si viene por JSON (desde JS) o por POST tradicional (formulario)
if ($_SERVER['CONTENT_TYPE'] === 'application/json') {
  $data = json_decode(file_get_contents('php://input'), true);
} else {
  $data = $_POST;
  $data['items'] = json_decode($data['json'] ?? '[]', true); // Desde formulario
}

// Validación básica
if (empty($data['nombre']) || empty($data['email']) || empty($data['items'])) {
  http_response_code(400);
  echo json_encode(['status' => 'error', 'message' => 'Faltan datos del pedido']);
  exit;
}

// Limpieza de datos

// Obtener negocio_id desde JSON (application/json) o POST tradicional
$negocio_id = $data['negocio_id'] ?? ($_POST['negocio_id'] ?? 0);

if (!$negocio_id) {
  http_response_code(403);
  echo json_encode(['status' => 'error', 'message' => 'Negocio no definido en la solicitud']);
  exit;
}
// Obtener datos del negocio desde la base de datos
$stmt_neg = $conn->prepare("SELECT nombre, descripcion, logo_url, email, telefono, direccion, horario_apertura, horario_cierre FROM negocios WHERE id = ?");
$stmt_neg->bind_param("i", $negocio_id);
$stmt_neg->execute();
$stmt_neg->bind_result($nombre_negocio, $descripcion_negocio, $logo_negocio, $email_negocio, $telefono_emp, $direccion_negocio, $apertura, $cierre);
$stmt_neg->fetch();
$stmt_neg->close();

// Asignar a variables usadas en el sistema
$logoUrl = $logo_negocio;
$_SESSION['telefono_emp'] = $telefono_emp;
$_SESSION['logo_emp'] = $logoUrl;



$nombre = $conn->real_escape_string($data['nombre']);
$comuna = $conn->real_escape_string($data['comuna'] ?? '');
$direccion = $conn->real_escape_string(trim($data['direccion'] ?? ''));
if ($direccion === '') {
  $direccion = "RETIRO TIENDA";
}
$total = (int) $data['total'];
$delivery_monto = isset($data['delivery_monto']) ? (int)$data['delivery_monto'] : 0;
$distancia_km = isset($data['distancia_km']) ? (float)$data['distancia_km'] : 0;
$descuento_aplicado = isset($data['descuento_aplicado']) ? (int)$data['descuento_aplicado'] : 0;
$estado = 'pendiente';
date_default_timezone_set('America/Santiago');
$fecha = date('Y-m-d H:i:s');
$items = $data['items'];
$telefono = $conn->real_escape_string($data['telefono'] ?? '');
$email = $conn->real_escape_string($data['email'] ?? '');
$comentarioDireccion = $conn->real_escape_string($data['comentarioDireccion'] ?? '');
$fechaHoraEntrega = $conn->real_escape_string($data['fecha_hora_entrega'] ?? null);


// Insertar pedido principal
$stmt = $conn->prepare("INSERT INTO pedidos (negocio_id, cliente_nombre, cliente_email, cliente_direccion, total, estado, fecha, delivery_monto, distancia_km, comentario_direccion, telefono, fecha_hora_entrega) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("isssissidsss", $negocio_id, $nombre, $email, $direccion, $total, $estado, $fecha, $delivery_monto, $distancia_km, $comentarioDireccion, $telefono, $fechaHoraEntrega);

if ($stmt->execute()) {
  $pedido_id = $stmt->insert_id;
  $numeroPedido = str_pad($pedido_id, 5, "0", STR_PAD_LEFT);

  include '../api/whatsapp_ultramsg.php';

  // Formatear teléfono
  $telefonoFormateado = preg_replace('/[^0-9]/', '', $telefono);
  if (strlen($telefonoFormateado) == 9) {
    $telefonoFormateado = '56' . $telefonoFormateado;
  }

  // Construir mensaje simple
  $mensajeWA = "Hola $nombre! Gracias por tu pedido. 
                  N° Pedido: #$numeroPedido
                  Total: $" . number_format($total, 0, ',', '.') . "
                  Productos: " . count($items) . "
                  Te avisaremos cuando esté listo.";

  // Enviar WhatsApp
  enviarWhatsapp($telefonoFormateado, $mensajeWA);

  // Insertar productos del pedido
  $item_stmt = $conn->prepare("INSERT INTO pedido_items (pedido_id, producto_id, cantidad, precio_unitario) VALUES (?, ?, ?, ?)");
  foreach ($items as $item) {
    $producto_id = (int) $item['id'];
    $cantidad = (int) $item['cantidad'];
    $precio_unitario = (int) $item['precio'];
    $item_stmt->bind_param("iiii", $pedido_id, $producto_id, $cantidad, $precio_unitario);
    $item_stmt->execute();
  }

  // Registrar movimiento de inventario por cada producto vendido
  $mov_stmt = $conn->prepare("INSERT INTO inventario_movimientos (producto_id, negocio_id, tipo_movimiento, cantidad, motivo, usuario_id) VALUES (?, ?, 'venta', ?, ?, NULL)");
  foreach ($items as $item) {
    $producto_id = (int) $item['id'];
    $cantidad = (int) $item['cantidad'];
    $motivo = "Venta N° $numeroPedido";
    $mov_stmt->bind_param("iiis", $producto_id, $negocio_id, $cantidad, $motivo);
    $mov_stmt->execute();

    // Actualizar el stock actual del producto
    $conn->query("UPDATE productos SET stock = stock - $cantidad WHERE id = $producto_id");
  }

  // Registrar descuento si existe
  if ($descuento_aplicado > 0) {
    $stmt_desc = $conn->prepare("INSERT INTO RegistroDescuentos (negocio_id, id_pedido, monto_descuento) VALUES (?, ?, ?)");
    $stmt_desc->bind_param("iii", $negocio_id, $pedido_id, $descuento_aplicado);
    $stmt_desc->execute();
  }

  // Enviar email si "telefono" es un correo
  if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $mail = new PHPMailer(true);
    $mail->CharSet = 'UTF-8';

    try {
      // Configuración SMTP
      $mail->isSMTP();
      $mail->Host       = 'smtp.gmail.com';
      $mail->SMTPAuth   = true;
      $mail->Username   = 'ddulcesysaladas@gmail.com';
      $mail->Password   = 'ptuy zwnj mowb hhlc';
      $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
      $mail->Port       = 587;

      // Configuración del email
      $mail->setFrom('ddulcesysaladas@gmail.com', 'Delicias Dulces y Saladas');
      $mail->addAddress($email, $nombre);

      $mail->isHTML(true);
      $mail->Subject = '🧆 Confirmación de tu pedido - Delicias Dulces y Saladas';

      $html = '
            <div style="font-family: Poppins, sans-serif; max-width: 600px; margin: auto; padding: 1.5rem; background: #fffefb; border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.05);">
              <div style="text-align: center; margin-bottom: 1rem;">
                <img src="http://168.232.165.4/Pedidos_Saas/images/' . htmlspecialchars($logoUrl) . '" alt="Logo" style="width: 100%; max-width: 180px; height: auto; display: block; margin: 0 auto;">
                <h2 style="color: #ff6f00;">¡Gracias por tu pedido, ' . htmlspecialchars($nombre) . '!</h2>
                <p style="color: #333; font-size: 0.95rem;">Número de pedido: #' . $numeroPedido . '</p>
                <p style="color: #555;">Aquí tienes el resumen de tu pedido:</p>
              </div>
              <table style="width: 100%; border-collapse: collapse; margin-top: 1rem;">
                <thead>
                  <tr style="background: #fff3e0;">
                    <th align="left" style="padding: 8px;">Producto</th>
                    <th align="center" style="padding: 8px;">Cantidad</th>
                    <th align="right" style="padding: 8px;">Subtotal</th>
                  </tr>
                </thead>
                <tbody>';

      foreach ($items as $item) {
        $subtotal = number_format($item['precio'] * $item['cantidad'], 0, ',', '.');
        $html .= '
                  <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 8px;">' . htmlspecialchars($item['nombre']) . '</td>
                    <td align="center" style="padding: 8px;">' . $item['cantidad'] . '</td>
                    <td align="right" style="padding: 8px;">$' . $subtotal . '</td>
                  </tr>';
      }

      $html .= '
                </tbody>
              </table>';

      if ($delivery_monto > 0) {
        $html .= '
                  <p style="text-align: right; font-size: 0.95rem; margin: 0.5rem 0;">
                    Delivery: $' . number_format($delivery_monto, 0, ',', '.') . ' (' . number_format($distancia_km, 1, ',', '.') . ' km)
                  </p>';
      }

      if ($descuento_aplicado > 0) {
        $html .= '
                  <p style="text-align: right; color: #ff6f00; font-size: 0.95rem; margin: 0.5rem 0;">
                    Descuento aplicado: -$' . number_format($descuento_aplicado, 0, ',', '.') . '
                  </p><br><hr>';
      }

      $html .= '
              
              <p style="font-size: 1.1rem; font-weight: bold; text-align: right; margin-top: 1rem;">
                Total a pagar: $' . number_format($total, 0, ',', '.') . '
              </p>
              ' . ($direccion !== 'RETIRO TIENDA' ? '<p><strong>Dirección:</strong> ' . htmlspecialchars($direccion) . '</p>' : '') . '
              ' . ($direccion !== 'RETIRO TIENDA' ?
        '<p style="text-align: center; margin-top: 2rem;">Te avisaremos pronto cuando tu pedido esté en camino 🍽️</p>' :
        '<p style="text-align: center; margin-top: 2rem;">Te avisaremos cuando tu pedido esté listo para retiro 🏪</p>') . '
              <div style="margin-top: 2rem; font-size: 0.95rem;">
                <p><strong>Opciones de pago:</strong></p>
                <ul style="padding-left: 1rem;">
                  <li>💳 Transferencia: Banco Estado, CTA RUT 12345678, a nombre de Juan Ejemplo</li>
                  <li>💵 Efectivo al recibir o al retirar</li>
                  <li>🔗 Webpay o Mercado Pago (link enviado aparte)</li>
                </ul>
              </div>
              <p style="text-align: center; font-size: 0.8rem; color: #aaa;">Dulces y Saladas - Gracias por confiar ❤️</p>
              <div style="text-align: center; margin-top: 2rem;">
                <a href="https://wa.me/' . $_SESSION['telefono_emp'] . '?text=' . urlencode("Hola, hice un pedido N° $numeroPedido,") . '" 
                   style="display: inline-block; padding: 12px 24px; background-color: #25D366; color: white; font-weight: bold; border-radius: 8px; text-decoration: none; font-size: 1rem;">
                  <img src="https://img.icons8.com/ios-filled/24/ffffff/whatsapp.png" alt="WhatsApp" style="vertical-align: middle; margin-right: 8px;">
                  Háblanos por WhatsApp
                </a>
              </div>
            </div>';

      $mail->Body = $html;
      $mail->send();
    } catch (Exception $e) {
      error_log('Error al enviar correo: ' . $mail->ErrorInfo);
    }
  }

  header('Location: ../index.php?msg=ok');
  exit;
} else {
  http_response_code(500);
  header('Location: ../index.php?msg=error');
  exit;
}
