<?php
require_once '../config/config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Recoger datos
$id = $_POST['id'] ?? '';
$negocio_id = $_POST['negocio_id'];
$nombre = $_POST['nombre'];
$email = $_POST['email'];
$password = $_POST['password'] ?? '';
$rol = $_POST['rol'];

// Validaciones mínimas
if (empty($negocio_id) || empty($nombre) || empty($email)) {
  die("Todos los campos son obligatorios.");
}

if ($id) {
  // Actualizar usuario
  if (!empty($password)) {
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $conn->prepare("UPDATE usuarios SET negocio_id = ?, nombre = ?, email = ?, password = ?, rol = ? WHERE id = ?");
    $stmt->bind_param("issssi", $negocio_id, $nombre, $email, $hash, $rol, $id);
  } else {
    $stmt = $conn->prepare("UPDATE usuarios SET negocio_id = ?, nombre = ?, email = ?, rol = ? WHERE id = ?");
    $stmt->bind_param("isssi", $negocio_id, $nombre, $email, $rol, $id);
  }
} else {
  // Nuevo usuario, contraseña obligatoria
  if (empty($password)) {
    die("La contraseña es obligatoria.");
  }
  $hash = password_hash($password, PASSWORD_DEFAULT);
  $stmt = $conn->prepare("INSERT INTO usuarios (negocio_id, nombre, email, password, rol) VALUES (?, ?, ?, ?, ?)");
  $stmt->bind_param("issss", $negocio_id, $nombre, $email, $hash, $rol);
}

if ($stmt->execute()) {
  // Redirigir de vuelta a la vista dentro del panel
  header("Location: panel.php?view=usuarios&guardado=1");
  exit;
} else {
  echo "Error al guardar usuario: " . $stmt->error;
}