<?php
ob_start();
session_start();
require_once '../config/config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

$negocio_id = $_SESSION['negocio_id']; // ID por defecto

$stmt = $conn->prepare("SELECT nombre, descripcion, logo_url, direccion, telefono, horario_apertura, horario_cierre FROM negocios WHERE id = ?");
$stmt->bind_param("i", $negocio_id);
$stmt->execute();
$resultado = $stmt->get_result();
$negocio = $resultado->fetch_assoc();

$stmt = $conn->prepare("SELECT COUNT(*) FROM productos WHERE negocio_id = ?");
$stmt->bind_param("i", $negocio_id);
$stmt->execute();
$stmt->bind_result($total_productos);
$stmt->fetch();
$stmt->close();

$stmt = $conn->prepare("SELECT COUNT(*) FROM pedidos WHERE negocio_id = ?");
$stmt->bind_param("i", $negocio_id);
$stmt->execute();
$stmt->bind_result($total_pedidos);
$stmt->fetch();
$stmt->close();
?>

<!DOCTYPE html>
<html lang="es">

<head>
  <meta charset="UTF-8">
  <title>Panel | <?php echo htmlspecialchars($negocio['nombre']); ?></title>
  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Incluir los estilos y scripts de DataTables -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.3/css/jquery.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.3/css/dataTables.bootstrap5.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.3/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.3/js/dataTables.bootstrap5.min.js"></script>

  <!-- SweetAlert2 -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <!-- Agregar Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

  <script>
    $(document).ready(function() {
      var table = $('#Table').DataTable({
        "language": {
          "sSearch": "Buscar:",
          "sLengthMenu": "Mostrar _MENU_ registros por página",
          "sInfo": "Mostrando _START_ a _END_ de _TOTAL_ registros",
          "oPaginate": {
            "sPrevious": "Anterior",
            "sNext": "Siguiente"
          }
        }
      });

      window.addEventListener("scroll", function() {
        const header = document.querySelector("header");
        if (window.scrollY > 10) {
          header.classList.add("scrolled");
        } else {
          header.classList.remove("scrolled");
        }
      });
    });
  </script>
  <style>
    body {
      background: linear-gradient(135deg, #e3f2fd, #ffffff);
      font-family: 'Roboto', sans-serif;
    }

    header {
      transition: all 0.3s ease-in-out;
      background-color: rgba(13, 110, 253, 0.95) !important;
      backdrop-filter: blur(4px);
    }

    header.scrolled {
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
      background-color: rgba(13, 110, 253, 0.85) !important;
    }

    .card {
      flex: 1 1 200px;
      padding: 0.5rem;
      background: #ffffff;
      border-radius: 12px;
      /* box-shadow: 0 4px 12px rgba(0,0,0,0.05);
      transition: transform 0.3s, box-shadow 0.3s;
    }
    .card:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 16px rgba(0,0,0,0.1);*/
    }

    .nav-link {
      font-weight: 600;
      margin-left: 1rem;
      transition: transform 0.2s ease, color 0.2s ease;
      transform-origin: center;
    }

    .nav-link:hover {
      color: #0d6efd;
      transform: scale(1.05);
    }
  </style>
</head>

<body>

  <header class="bg-primary py-2 shadow-sm" style="position: fixed; top: 0; left: 0; width: 100%; z-index: 1030;">
    <div class="container-fluid px-4 d-flex justify-content-between align-items-center">
      <div class="me-auto">
        <span class="text-white fs-5 fw-bold">
          <?php echo htmlspecialchars($negocio['nombre']); ?>
        </span>
      </div>

      <nav class="nav bg-white rounded-3 px-3 py-2 shadow-sm d-flex flex-wrap gap-2">
        <?php if ($_SESSION['rol'] === 'superadmin'): ?>
          <a class="nav-link text-dark" href="panel.php">Inicio</a>
          <a class="nav-link text-dark" href="panel.php?view=productos">Productos</a>
          <a class="nav-link text-dark" href="panel.php?view=pedidos">Pedidos</a>
          <a class="nav-link text-dark" href="panel.php?view=ingreso_inventario">Inventario</a>
          <a class="nav-link text-dark" href="panel.php?view=negocios">Negocios</a>
          <a class="nav-link text-dark" href="panel.php?view=usuarios">Usuarios</a>
          <a class="nav-link text-danger" href="../logout.php" title="Cerrar sesión">
            <i class="fas fa-sign-out-alt"></i>
          </a>
        <?php elseif ($_SESSION['rol'] === 'admin'): ?>
          <a class="nav-link text-dark" href="panel.php">Inicio</a>
          <a class="nav-link text-dark" href="panel.php?view=productos">Productos</a>
          <a class="nav-link text-dark" href="panel.php?view=pedidos">Pedidos</a>
          <a class="nav-link text-dark" href="panel.php?view=ingreso_inventario">Inventario</a>
          <a class="nav-link text-danger" href="../logout.php" title="Cerrar sesión">
            <i class="fas fa-sign-out-alt"></i>
          </a>
        <?php elseif ($_SESSION['rol'] === 'empleado'): ?>
          <a class="nav-link text-dark" href="panel.php?view=pedidos">Pedidos</a>
          <a class="nav-link text-danger" href="../logout.php" title="Cerrar sesión">
            <i class="fas fa-sign-out-alt"></i>
          </a>
        <?php endif; ?>
      </nav>
    </div>
  </header>

  <div style="height: 72px;"></div>

  <main style="background: linear-gradient(180deg,#0d6efd, #e2ebf0); min-height: 100vh;">
    <div class="w-100 px-3 py-3" style="width: 99%;">
      <div class="card rounded-4">

        <div class="card-body">

          <?php
          $vista = $_GET['view'] ?? 'dashboard';
          $archivo = __DIR__ . "/views/{$vista}.php";
          if (file_exists($archivo)) {
            include $archivo;
          } else {
            echo "<div class='alert alert-danger'>Vista no encontrada</div>";
          }
          ?>
        </div>
      </div>
    </div>
  </main>

</body>

<?php ob_end_flush(); ?>

</html>