<?php
require_once '../config/config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Recoger datos
$id          = $_POST['id'] ?? '';
$negocio_id  = $_POST['negocio_id'];
$nombre      = $_POST['nombre'];
$descripcion = $_POST['descripcion'] ?? '';
$precio      = $_POST['precio'];
$stock       = $_POST['stock'];
$categoria   = $_POST['categoria'];
$categoria1  = $_POST['categoria1'];
$categoria2  = $_POST['categoria2'];
$categoria3  = $_POST['categoria3'];
$activo      = isset($_POST['activo']) ? 1 : 0;

$tipo_producto = $_POST['tipo_producto'] ?? '';
$fecha_inicio = !empty($_POST['hrs_produccion']) ? $_POST['hrs_produccion'] : null;
$fecha_fin = !empty($_POST['Apedido']) ? $_POST['Apedido'] : null;
$sobreventa = isset($_POST['sobreventa']) ? 1 : 0;
$unidad_medida = $_POST['unidad_medida'] ?? '';
$sku = $_POST['sku'] ?? '';
$codigo_barras = $_POST['codigo_barras'] ?? '';
$precio_oferta = isset($_POST['precio_oferta']) && $_POST['precio_oferta'] !== '' ? floatval($_POST['precio_oferta']) : null;
$stock_minimo = $_POST['stock_minimo'] ?? null;
$ubicacion = $_POST['ubicacion'] ?? '';
$notas = $_POST['notas'] ?? '';

// Validar
if (empty($nombre) || empty($precio)) {
  die("Nombre y precio son obligatorios.");
}

// Procesar imagen
$imagen_url = '';
if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] === UPLOAD_ERR_OK) {
  $directorio = '../images/productos/';
  if (!is_dir($directorio)) {
    mkdir($directorio, 0755, true);
  }

  $ext = pathinfo($_FILES['imagen']['name'], PATHINFO_EXTENSION);
  $nombre_archivo = uniqid('prod_') . '.' . strtolower($ext);
  $ruta_destino = $directorio . $nombre_archivo;

  if (move_uploaded_file($_FILES['imagen']['tmp_name'], $ruta_destino)) {
    $imagen_url =  $nombre_archivo;
  }
}

// INSERT o UPDATE
if ($id) {
  if ($imagen_url) {
    $stmt = $conn->prepare("UPDATE productos SET nombre=?, descripcion=?, imagen_url=?, precio=?, stock=?, categoria=?, categoria1=?, categoria2=?, categoria3=?, activo=?, tipo_producto=?, hrs_produccion=?, Apedido=?, sobreventa=?, unidad_medida=?, sku=?, codigo_barras=?, precio_oferta=?, stock_minimo=?, ubicacion=?, notas=? WHERE id=? AND negocio_id=?");
    $stmt->bind_param("sssdissssisssissssdssii", $nombre, $descripcion, $imagen_url, $precio, $stock, $categoria, $categoria1, $categoria2, $categoria3, $activo, $tipo_producto, $fecha_inicio, $fecha_fin, $sobreventa, $unidad_medida, $sku, $codigo_barras, $precio_oferta, $stock_minimo, $ubicacion, $notas, $id, $negocio_id);
  } else {
    $stmt = $conn->prepare("UPDATE productos SET nombre=?, descripcion=?, precio=?, stock=?, categoria=?, categoria1=?, categoria2=?, categoria3=?, activo=?, tipo_producto=?, hrs_produccion=?, Apedido=?, sobreventa=?, unidad_medida=?, sku=?, codigo_barras=?, precio_oferta=?, stock_minimo=?, ubicacion=?, notas=? WHERE id=? AND negocio_id=?");
    $stmt->bind_param("ssddssssisssissssdssii", $nombre, $descripcion, $precio, $stock, $categoria, $categoria1, $categoria2, $categoria3, $activo, $tipo_producto, $fecha_inicio, $fecha_fin, $sobreventa, $unidad_medida, $sku, $codigo_barras, $precio_oferta, $stock_minimo, $ubicacion, $notas, $id, $negocio_id);
  }
} else {
  $stmt = $conn->prepare("INSERT INTO productos (negocio_id, nombre, descripcion, imagen_url, precio, stock, categoria, categoria1, categoria2, categoria3, activo, tipo_producto, hrs_produccion, Apedido, sobreventa, unidad_medida, sku, codigo_barras, precio_oferta, stock_minimo, ubicacion, notas) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
  $stmt->bind_param("isssdiisssisssissssdss", $negocio_id, $nombre, $descripcion, $imagen_url, $precio, $stock, $categoria, $categoria1, $categoria2, $categoria3, $activo, $tipo_producto, $fecha_inicio, $fecha_fin, $sobreventa, $unidad_medida, $sku, $codigo_barras, $precio_oferta, $stock_minimo, $ubicacion, $notas);
}

if ($stmt->execute()) {
  header("Location: panel.php?view=productos&guardado=1");

  exit;
} else {
  echo "❌ Error al guardar producto: " . $stmt->error;
}
