<?php
require_once '../config/config.php';
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
session_start();

$negocio_id = $_SESSION['negocio_id'] ?? 1;
$mensaje = "";

// Guardar movimiento
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $tipo = $_POST['tipo'];
    $motivo = $_POST['motivo'];
    $productosPOST = $_POST['productos'] ?? [];

    foreach ($productosPOST as $item) {
        $producto_id = intval($item['id']);
        $cantidad = floatval($item['cantidad']);

        $res = $conn->query("SELECT stock FROM productos WHERE id = $producto_id");
        $stock_anterior = (int) $res->fetch_assoc()['stock'];

        if ($tipo === 'entrada') {
            $stock_actual = $stock_anterior + $cantidad;
        } elseif ($tipo === 'salida') {
            $stock_actual = $stock_anterior - $cantidad;
        } else {
            $stock_actual = $cantidad;
        }

        $stmt = $conn->prepare("INSERT INTO inventario_movimientos 
        (producto_id, negocio_id, tipo_movimiento, cantidad, motivo, usuario_id, stock_anterior, stock_actual)
        VALUES (?, ?, ?, ?, ?, NULL, ?, ?)");
        $stmt->bind_param("iisdsii", $producto_id, $negocio_id, $tipo, $cantidad, $motivo, $stock_anterior, $stock_actual);
        $stmt->execute();

        $conn->query("UPDATE productos SET stock = $stock_actual WHERE id = $producto_id");
    }

    $mensaje = "Movimientos registrados correctamente.";
}

// Obtener productos
$productos = $conn->query("SELECT id, nombre FROM productos WHERE negocio_id = $negocio_id ORDER BY nombre ASC");
?>

<!-- Quill CSS -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<!-- Quill JS -->
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
<!-- Select2 CSS & JS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
    .form-control,
    .form-select {
        border: 1px solid #ced4da;
        box-shadow: none;
        background-color: #fff;
    }

    .form-control:focus,
    .form-select:focus {
        border-color: #80bdff;
        outline: 0;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, .25);
    }

    .card {
        background-color: #ffffff;
        border-radius: 10px;
        border: 1px solid #dee2e6;
    }

    body {
        background: linear-gradient(to bottom, #f0f4ff, #ffffff);
    }

    /* Estilo para Select2 con bootstrap-5 para mantener borde y padding */
    .select2-container--bootstrap-5 .select2-selection {
        border: 1px solid #ced4da !important;
        padding: 0.375rem 0.75rem !important;
        height: auto !important;
        min-height: 38px;
    }

    .form-control,
    .form-select,
    .select2-container--bootstrap-5 .select2-selection {
        border-radius: 0.5rem !important;
        padding-left: 0.75rem !important;
        padding-right: 0.75rem !important;
    }
</style>

<div class="container py-4">
    <div class="card border-0 rounded-4 px-4">
        <div class="card-body">
            <h4 class="mb-4 text-center">Ingreso o Ajuste de Inventario</h4>

            <?php if ($mensaje): ?>
                <script>
                    Swal.fire('✔️ Éxito', '<?= $mensaje ?>', 'success');
                </script>
            <?php endif; ?>

            <form method="POST" id="formInventario" class="row g-4">
                <div class="col-md-6">
                    <label for="tipo" class="form-label">Tipo de Movimiento</label>
                    <select name="tipo" id="tipo" class="form-select" required>
                        <option value="entrada">Entrada</option>
                        <option value="salida">Salida</option>
                        <option value="ajuste">Ajuste</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label for="motivo" class="form-label">Motivo</label>
                    <input type="text" name="motivo" id="motivo" class="form-control" required>
                </div>

                <div class="col-12">
                    <button type="button" class="btn btn-outline-primary mb-2" onclick="agregarLinea()">➕ Agregar Producto</button>
                </div>

                <div id="productosContainer" class="col-12">
                    <!-- Aquí se insertarán las líneas de producto -->
                </div>

                <div class="col-12 text-end">
                    <button type="submit" class="btn btn-success px-4">Guardar Movimiento</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    const productos = <?= json_encode($conn->query("SELECT id, nombre FROM productos WHERE negocio_id = $negocio_id ORDER BY nombre ASC")->fetch_all(MYSQLI_ASSOC), JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP); ?>;

    function agregarLinea() {
        const container = document.getElementById('productosContainer');
        const index = document.querySelectorAll('.producto-linea').length;
        const div = document.createElement('div');
        div.className = 'row g-2 align-items-center producto-linea mb-2';

        const select = document.createElement('select');
        select.name = `productos[${index}][id]`;
        select.className = 'form-select col';
        select.required = true;
        select.innerHTML = `<option value="">Producto...</option>` + productos.map(p => `<option value="${p.id}">${p.nombre}</option>`).join('');

        const input = document.createElement('input');
        input.type = 'number';
        input.name = `productos[${index}][cantidad]`;
        input.className = 'form-control col';
        input.step = '0.01';
        input.min = '0.01';
        input.placeholder = 'Cantidad';
        input.required = true;

        const col1 = document.createElement('div');
        col1.className = 'col-md-8';
        col1.appendChild(select);

        const col2 = document.createElement('div');
        col2.className = 'col-md-4';
        col2.appendChild(input);

        div.appendChild(col1);
        div.appendChild(col2);

        container.appendChild(div);
        $(select).select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
    }

    document.addEventListener('DOMContentLoaded', () => {
        agregarLinea();
    });
</script>