<?php
session_start();
require_once '../config/config.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

$modo = "Crear";
$negocio = [
  'id' => '',
  'nombre' => '',
  'descripcion' => '',
  'logo_url' => '',
  'email' => '',
  'telefono' => '',
  'direccion' => '',
  'horario_apertura' => '',
  'horario_cierre' => '',
  'activo' => 1
];

// Si viene con ID (modo edición)
if (isset($_GET['id'])) {
  $id = intval($_GET['id']);
  $stmt = $conn->prepare("SELECT * FROM negocios WHERE id = ?");
  $stmt->bind_param("i", $id);
  $stmt->execute();
  $resultado = $stmt->get_result();
  if ($resultado->num_rows > 0) {
    $negocio = $resultado->fetch_assoc();
    $modo = "Editar";
  }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title><?php echo $modo; ?> Negocio</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f1f1f1;
      font-family: 'Roboto', sans-serif;
    }
  </style>
</head>
<body>

<div class="container py-4">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">
      <h4 class="mb-4"><?php echo $modo; ?> Negocio</h4>

      <form action="panel.php?view=guardar_negocio" method="POST">
        <input type="hidden" name="id" value="<?php echo $negocio['id']; ?>">

        <div class="mb-3">
          <label for="nombre" class="form-label">Nombre:</label>
          <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo htmlspecialchars($negocio['nombre']); ?>" required>
        </div>

        <div class="mb-3">
          <label for="descripcion" class="form-label">Descripción:</label>
          <textarea class="form-control" id="descripcion" name="descripcion"><?php echo htmlspecialchars($negocio['descripcion']); ?></textarea>
        </div>

        <div class="mb-3">
          <label for="logo_url" class="form-label">Logo (URL):</label>
          <input type="text" class="form-control" id="logo_url" name="logo_url" value="<?php echo htmlspecialchars($negocio['logo_url']); ?>">
        </div>

        <div class="mb-3">
          <label for="email" class="form-label">Email:</label>
          <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($negocio['email']); ?>">
        </div>

        <div class="mb-3">
          <label for="telefono" class="form-label">Teléfono:</label>
          <input type="text" class="form-control" id="telefono" name="telefono" value="<?php echo htmlspecialchars($negocio['telefono']); ?>">
        </div>

        <div class="mb-3">
          <label for="direccion" class="form-label">Dirección:</label>
          <input type="text" class="form-control" id="direccion" name="direccion" value="<?php echo htmlspecialchars($negocio['direccion']); ?>">
        </div>

        <div class="row mb-3">
          <div class="col-md-6">
            <label for="horario_apertura" class="form-label">Horario Apertura:</label>
            <input type="time" class="form-control" id="horario_apertura" name="horario_apertura" value="<?php echo $negocio['horario_apertura']; ?>">
          </div>
          <div class="col-md-6">
            <label for="horario_cierre" class="form-label">Horario Cierre:</label>
            <input type="time" class="form-control" id="horario_cierre" name="horario_cierre" value="<?php echo $negocio['horario_cierre']; ?>">
          </div>
        </div>

        <div class="form-check mb-3">
          <input type="checkbox" class="form-check-input" id="activo" name="activo" value="1" <?php echo $negocio['activo'] ? 'checked' : ''; ?>>
          <label class="form-check-label" for="activo">Activo</label>
        </div>

        <div class="text-end">
          <a href="panel.php?view=negocios" class="btn btn-outline-secondary">Cancelar</a>
          <button type="submit" class="btn btn-primary">Guardar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
