<?php
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

$result = $conn->query("SELECT * FROM negocios ORDER BY fecha_registro DESC");
?>

<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mt-2 mb-3">
    <h4 class="mb-0 fw-semibold">
      <i class="fas fa-store me-2 text-primary"></i>Negocios Registrados
    </h4>
    <div>
      <a href="panel.php?view=negocio_form" class="btn btn-success btn-sm">+ Agregar Negocio</a>
    </div>
  </div>

  <div class="table-responsive">
  <table id="tabla_negocios" class="table table-hover table-bordered table-striped align-middle text-center" style="width: 100%;">
    <thead>
      <tr>
        <th>Nombre</th>
        <th>Email</th>
        <th>Teléfono</th>
        <th>Activo</th>
        <th>Acciones</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($negocio = $result->fetch_assoc()): ?>
        <tr>
          <td><?php echo htmlspecialchars($negocio['nombre']); ?></td>
          <td><?php echo htmlspecialchars($negocio['email']); ?></td>
          <td><?php echo htmlspecialchars($negocio['telefono']); ?></td>
          <td><?php echo $negocio['activo'] ? 'Sí' : 'No'; ?></td>
          <td>
            <a href="panel.php?view=negocio_form&id=<?= $negocio['id'] ?>" class="btn btn-outline-primary btn-sm rounded-circle" title="Editar">
              <i class="fas fa-pen"></i>
            </a>
            <a href="panel.php?view=eliminar_negocio&id=<?= $negocio['id'] ?>" class="btn btn-outline-danger btn-sm rounded-circle" title="Eliminar" onclick="return confirm('¿Estás seguro de eliminar este negocio?');">
              <i class="fas fa-trash"></i>
            </a>
          </td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>
</div>

  <!-- DataTables -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css"/>
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <script>
    $(document).ready(function () {
      $('#tabla_negocios thead tr')
        //.clone(true)
        .addClass('filters')
        .appendTo('#tabla_negocios thead');

      let table = $('#tabla_negocios').DataTable({
        responsive: true,
        orderCellsTop: true,
        // fixedHeader: true,
        language: {
          search: "🔍 Buscar:",
          lengthMenu: "Mostrar _MENU_ registros",
          info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
          paginate: {
            previous: "Anterior",
            next: "Siguiente"
          }
        },
       /* initComplete: function () {
          this.api().columns().every(function (i) {
            let column = this;
            let cell = $('.filters th').eq(i).empty();
            $('<input type="text" placeholder="Filtrar" style="width: 100%; padding: 4px;" />')
              .appendTo(cell)
              .on('keyup change', function () {
                column.search($(this).val()).draw();
              });
          });
        }*/
      });
    });
  </script>