<?php
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$negocio_id = $_SESSION['negocio_id'] ?? 0;
$filtro = $_GET['filtro'] ?? ''; // Si no viene nada, queda vacío
$query = "SELECT p.id, p.cliente_nombre, p.telefono, p.total, p.fecha , p.estado, p.fecha_hora_entrega
          FROM pedidos p 
          WHERE p.negocio_id = ?
          ORDER BY FIELD(p.estado, 'pendiente') DESC, p.fecha ASC";

$stmt = $conn->prepare($query);
$stmt->bind_param("i", $negocio_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<div class="container-fluid">
  <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mt-2 mb-3">
    <h4 class="mb-0 fw-semibold">
      <i class="fas fa-clipboard-list me-2 text-primary"></i>📋 Pedidos Pendientes
    </h4>
    <div class="d-flex flex-wrap gap-2">
      <button onclick="window.open('imprimir_pendientes.php', '_blank')" class="btn btn-primary btn-sm">
        <i class="fas fa-print"></i> Imprimir Todos
      </button>
      <button id="cambiarEstadoBtn" class="btn btn-success btn-sm" disabled>
        <i class="fas fa-edit"></i> Cambiar Estado
      </button>
    </div>
  </div>

  <div class="table-responsive">
    <table id="tabla_pedidos" class="table table-hover table-bordered table-striped align-middle text-center" style="width: 100%;">
      <thead>
        <tr>
          <th><input type="checkbox" id="selectAll"></th>
          <th>Estado</th>
          <th>ID</th>
          <th>Cliente</th>
          <th>Teléfono</th>
          <th>Total</th>
          <th>F. Compra</th>
          <th>F. Entrega</th>
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($pedido = $result->fetch_assoc()): ?>
          <tr>
            <td><input type="checkbox" class="pedidoCheckbox" value="<?php echo $pedido['id']; ?>"></td>
            <td>
            <?php
              $estado = strtolower($pedido['estado']);

              $estadoIcon = match ($estado) {
                'pendiente'     => '🕓',
                'preparando'    => '👨‍🍳',
                'preparado'     => '🍽️',
                'listoretiro'   => '📦',
                'despachado'    => '🚚',
                'entregado'     => '✅',
                'cancelado'     => '❌',
                default         => '❔'
              };

              $estadoClass = match ($estado) {
                'pendiente'     => 'estado-pendiente',
                'preparando'    => 'estado-preparando',
                'preparado'     => 'estado-preparado',
                'listoretiro'   => 'estado-listoretiro',
                'despachado'    => 'estado-despachado',
                'entregado'     => 'estado-entregado',
                'cancelado'     => 'estado-cancelado',
                default         => 'estado-otro'
              };
            ?>
           <span class="badge-estado <?php echo $estadoClass; ?>" data-estado="<?php echo ucfirst($estado); ?>">
              <span class="emoji"><?php echo $estadoIcon; ?></span> <?php echo ucfirst($estado); ?>
            </span>

            </td>
            <td>#<?php echo $pedido['id']; ?></td>
            <td><?php echo htmlspecialchars($pedido['cliente_nombre']); ?></td>
            <td><?php echo htmlspecialchars($pedido['telefono']); ?></td>
            <td>$<?php echo number_format($pedido['total'], 0, ',', '.'); ?></td>
            <td><?php echo date("d/m/Y H:i", strtotime($pedido['fecha'])); ?></td>
             
            <td>
              <?php echo !empty($pedido['fecha_hora_entrega']) ? date("d/m/Y H:i", strtotime($pedido['fecha_hora_entrega'])) : ''; ?>
            </td>
            <td class="acciones-pedido">
              <a href="panel.php?view=ver_pedido&id=<?php echo $pedido['id']; ?>" class="btn btn-outline-primary btn-sm rounded-circle" title="Ver pedido">
                <i class="fas fa-eye"></i>
              </a>
              <a href="imprimir_pedido.php?id=<?php echo $pedido['id']; ?>" target="_blank" class="btn btn-outline-secondary btn-sm rounded-circle" title="Imprimir ticket">
                <i class="fas fa-print"></i>
              </a>
            </td>

          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>

  <!-- DataTables -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css"/>
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <script>
    $(document).ready(function () {
      $('#tabla_pedidos thead tr')
        .clone(true)
        .addClass('filters')
        .appendTo('#tabla_pedidos thead');

      let table = $('#tabla_pedidos').DataTable({
        responsive: true,
        orderCellsTop: true,
        order: [[7, 'desc']],
        language: {
          search: "🔍 Buscar:",
          lengthMenu: "Mostrar _MENU_ registros",
          info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
          paginate: {
            previous: "Anterior",
            next: "Siguiente"
          }
        },
        initComplete: function () {
          this.api().columns().every(function (i) {
            let column = this;
            if (i === 1) { // Estado
              let select = $('<select style="width: 100%; padding: 4px;"><option value="">Estado</option></select>')
                .appendTo($('.filters th').eq(i).empty())
                .on('change', function () {
                  let val = $.fn.dataTable.util.escapeRegex($(this).val());
                  column.search(val, true, false).draw();
                });
              column.data().unique().sort().each(function (d, j) {
                let estado = $(d).data('estado') || $('<div>' + d + '</div>').text();
                select.append('<option value="' + estado + '">' + estado + '</option>');
              });
            } else {
              let cell = $('.filters th').eq(i).empty();
              $('<input type="text" placeholder="Filtrar" style="width: 100%; padding: 4px;" />')
                .appendTo(cell)
                .on('keyup change', function () {
                  column.search($(this).val()).draw();
                });
            }
          });
        }
      });
    });
  </script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
  const checkboxes = document.querySelectorAll('.pedidoCheckbox');
  const cambiarEstadoBtn = document.getElementById('cambiarEstadoBtn');
  const selectAll = document.getElementById('selectAll');

  checkboxes.forEach(cb => {
    cb.addEventListener('change', () => {
      cambiarEstadoBtn.disabled = document.querySelectorAll('.pedidoCheckbox:checked').length === 0;
    });
  });

  selectAll.addEventListener('change', (e) => {
    checkboxes.forEach(cb => cb.checked = e.target.checked);
    cambiarEstadoBtn.disabled = document.querySelectorAll('.pedidoCheckbox:checked').length === 0;
  });

  cambiarEstadoBtn.addEventListener('click', () => {
    const seleccionados = Array.from(document.querySelectorAll('.pedidoCheckbox:checked')).map(cb => cb.value);

    if (seleccionados.length === 0) {
      Swal.fire('Error', 'Selecciona al menos un pedido.', 'error');
      return;
    }

    Swal.fire({
      title: 'Cambiar Estado',
      input: 'select',
      inputOptions: {
        'pendiente': 'Pendiente',
        'preparando': 'Preparando',
        'preparado': 'Preparado',
        'listoretiro': 'Listo para Retiro',
        'despachado': 'Despachado',
        'entregado': 'Entregado',
        'cancelado': 'Cancelado'
      },
      inputPlaceholder: 'Seleccione nuevo estado',
      showCancelButton: true,
      confirmButtonText: 'Cambiar',
      cancelButtonText: 'Cancelar',
    }).then((result) => {
      if (result.isConfirmed && result.value) {
        fetch('cambiar_estado_pedidos.php', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({
            ids: seleccionados,
            nuevo_estado: result.value
          })
        })
        .then(response => response.json())
        .then(data => {
          if (data.success) {
            Swal.fire('¡Actualizado!', data.message, 'success').then(() => {
              location.reload();
            });
          } else {
            Swal.fire('Error', data.message, 'error');
          }
        });
      }
    });
  });
  </script>
  <style>
     .badge-estado {
    padding: 6px 14px;
    border-radius: 5px;
    font-size: 0.9rem;
    font-weight: bold;
    color: white;
    text-transform: capitalize;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
  }

  /* Íconos con sombra y más grandes */
  /* .badge-estado::before {
    font-size: 1.2rem;
    filter: drop-shadow(1px 1px 1px rgba(0,0,0,0.3));
  } */

  /* Colores por estado */
  .estado-pendiente     { background-color: #f1c40f; }
  .estado-preparando    { background-color: #fd7e14; }
  .estado-preparado     { background-color: #6f42c1; }
  .estado-listoretiro   { background-color: #20c997; }
  .estado-despachado    { background-color: #17a2b8; }
  .estado-entregado     { background-color: #28a745; }
  .estado-cancelado     { background-color: #dc3545; }
  .estado-otro          { background-color: #6c757d; }

  #tabla_pedidos td:first-child, #tabla_pedidos th:first-child {
    width: 40px;
  }
  </style>
</div>