<?php if (isset($_GET['guardado'])): ?>
  <div style="background: #dff0d8; padding: 1rem; border-radius: 8px; color: #3c763d; margin-bottom: 1rem;">
    ✅ Usuario guardado correctamente.
  </div>
<?php endif; ?>
<?php
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

$modo = "Crear";
$usuario = [
  'id' => '',
  'negocio_id' => '',
  'nombre' => '',
  'email' => '',
  'rol' => 'empleado'
];

// Obtener negocios para el <select>
$negocios = $conn->query("SELECT id, nombre FROM negocios ORDER BY nombre");

// Si viene con ?id para editar
if (isset($_GET['id'])) {
  $id = intval($_GET['id']);
  $stmt = $conn->prepare("SELECT * FROM usuarios WHERE id = ?");
  $stmt->bind_param("i", $id);
  $stmt->execute();
  $resultado = $stmt->get_result();
  if ($resultado->num_rows > 0) {
    $usuario = $resultado->fetch_assoc();
    $modo = "Editar";
  }
}
?>

<div class="container py-4">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">
      <h4 class="mb-4"><?php echo $modo; ?> Usuario</h4>

      <form action="guardar_usuario.php" method="POST">
        <input type="hidden" name="id" value="<?php echo $usuario['id']; ?>">

        <div class="mb-3">
          <label for="negocio_id" class="form-label">Negocio:</label>
          <select name="negocio_id" id="negocio_id" required class="form-select">
            <option value="">-- Selecciona un negocio --</option>
            <?php while ($n = $negocios->fetch_assoc()): ?>
              <option value="<?php echo $n['id']; ?>" <?php echo ($usuario['negocio_id'] == $n['id']) ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($n['nombre']); ?>
              </option>
            <?php endwhile; ?>
          </select>
        </div>

        <div class="mb-3">
          <label for="nombre" class="form-label">Nombre:</label>
          <input type="text" name="nombre" id="nombre" class="form-control" value="<?php echo htmlspecialchars($usuario['nombre']); ?>" required>
        </div>

        <div class="mb-3">
          <label for="email" class="form-label">Email:</label>
          <input type="email" name="email" id="email" class="form-control" value="<?php echo htmlspecialchars($usuario['email']); ?>" required>
        </div>

        <div class="mb-3">
          <label for="password" class="form-label">Contraseña:</label>
          <input type="password" name="password" id="password" class="form-control" <?php echo $modo === 'Crear' ? 'required' : ''; ?>>
          <?php if ($modo === 'Editar') echo '<small class="text-muted">Dejar en blanco para mantener la actual</small>'; ?>
        </div>

        <div class="mb-3">
          <label for="rol" class="form-label">Rol:</label>
          <select name="rol" id="rol" required class="form-select">
            <option value="admin" <?php echo ($usuario['rol'] === 'admin') ? 'selected' : ''; ?>>Admin</option>
            <option value="empleado" <?php echo ($usuario['rol'] === 'empleado') ? 'selected' : ''; ?>>Empleado</option>
          </select>
        </div>

        <div class="text-end mt-4">
          <a href="panel.php?view=usuarios" class="btn btn-outline-secondary">Cancelar</a>
          <button type="submit" class="btn btn-primary">Guardar</button>
        </div>
      </form>
    </div>
  </div>
</div>
