<?php
require_once 'config/config.php';
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$negocio_id = 1;
$_SESSION['index'] = 'index.php';
$_SESSION['logo_url'] = 'logoN1.png';

// Obtener todas las categorias únicas desde categoria, categoria1, categoria2, categoria3
$categoriasQuery = "
  SELECT DISTINCT categoria 
  FROM productos 
  WHERE negocio_id = $negocio_id AND categoria IS NOT NULL AND categoria != ''

  UNION

  SELECT DISTINCT categoria1 
  FROM productos 
  WHERE negocio_id = $negocio_id AND categoria1 IS NOT NULL AND categoria1 != ''

  UNION

  SELECT DISTINCT categoria2 
  FROM productos 
  WHERE negocio_id = $negocio_id AND categoria2 IS NOT NULL AND categoria2 != ''

  UNION

  SELECT DISTINCT categoria3 
  FROM productos 
  WHERE negocio_id = $negocio_id AND categoria3 IS NOT NULL AND categoria3 != ''

";
$categoriasResult = $conn->query($categoriasQuery);
$categorias = [];
while ($row = $categoriasResult->fetch_assoc()) {
  $categorias[] = $row['categoria'];
}

// Filtro actual
$filtro = isset($_GET['filtro']) ? $_GET['filtro'] : null;
$busqueda = isset($_GET['busqueda']) ? strtolower(trim($_GET['busqueda'])) : '';

$stmt = $conn->prepare("SELECT * FROM productos WHERE negocio_id = ? AND activo = 1");
$stmt->bind_param("i", $negocio_id);
$stmt->execute();
$productos = $stmt->get_result();

$filtrados = [];
while ($p = $productos->fetch_assoc()) {
  $nombreLower = strtolower($p['nombre']);
  if ((
      !$filtro || in_array($filtro, [$p['categoria'], $p['categoria1'], $p['categoria2'], $p['categoria3']])
    ) &&
    (!$busqueda || strpos($nombreLower, $busqueda) !== false)
  ) {
    $cat = $p['categoria'] ?: 'Otros';
    $filtrados[$cat][] = $p;
  }
}
?>

<?php if (isset($_GET['msg']) && $_GET['msg'] === 'ok'): ?>
  <script>
    window.addEventListener('DOMContentLoaded', () => {
      Swal.fire({
        icon: 'success',
        title: '¡Gracias!',
        text: 'Tu pedido fue registrado correctamente.',
        timer: 3000,
        showConfirmButton: false
      });
      localStorage.removeItem('carrito');
      carrito = {};
      document.getElementById('total').innerText = '0';
      document.querySelectorAll('[id^="cantidad-"]').forEach(el => {
        el.innerText = '0';
      });
      calcularTotal();
    });
  </script>
<?php endif; ?>

<!DOCTYPE html>
<html lang="es">

<head>
  <meta charset="UTF-8">
  <title>Tienda Demo - Empanadas</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <!-- Cambia dentro del <head> el CSS por este -->
  <!-- Estilo tipo App de Delivery -->
  <style>
    * {
      box-sizing: border-box;
    }

    body {
      font-family: 'Poppins', sans-serif;
      margin: 0;
      background-color: #fefefe;
      color: #333;
    }

    header {
      background: #ffffff;
      padding: 1rem;
      display: flex;
      align-items: center;
      justify-content: center;
      position: sticky;
      top: 0;
      z-index: 1000;
      transition: padding 0.3s ease, box-shadow 0.3s ease;
    }

    /* Tamaño del logo original */
    header img {
      height: 160px;
      transition: height 0.3s ease;
    }

    /* Clase para reducir tamaño y agregar sombra al hacer scroll */
    .header-small {
      padding: 0.5rem;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      /* Sombra solo abajo */
    }

    /* Tamaño reducido del logo */
    .header-small img {
      height: 60px;
    }


    .slider {
      height: 260px;
      overflow: hidden;
      border-radius: 12px;
      margin: 1rem;
    }

    .slides {
      display: flex;
      animation: slide 20s infinite ease-in-out;
    }

    .slides img {
      width: 100%;
      height: 260px;
      object-fit: cover;
      flex-shrink: 0;
    }

    @keyframes slide {

      0%,
      20% {
        transform: translateX(0%);
      }

      25%,
      45% {
        transform: translateX(-100%);
      }

      50%,
      70% {
        transform: translateX(-200%);
      }

      75%,
      95% {
        transform: translateX(-300%);
      }

      100% {
        transform: translateX(-400%);
      }
    }

    .categoria {
      padding: 1rem;
    }

    .categoria h3 {
      font-size: 1.3rem;
      margin-bottom: 1rem;
      color: #ff6f00;
      font-weight: 600;
    }

    .producto {
      background: #fff;
      border-radius: 16px;
      box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
      overflow: hidden;
      margin-bottom: 1rem;
      display: flex;
      flex-direction: column;
      transition: transform 0.2s, box-shadow 0.3s;
    }

    .producto:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
    }

    .producto img {
      width: 100%;
      height: 140px;
      object-fit: cover;
    }

    .producto-info {
      padding: 0.8rem 1rem;
    }

    .producto-info .nombre {
      font-weight: 600;
      font-size: 1.1rem;
      margin-bottom: 0.3rem;
    }

    .producto-info .precio {
      color: #666;
      margin-bottom: 0.6rem;
    }


    .contador {
      display: flex;
      justify-content: center;
      /* Centrar botones y contador */
      align-items: center;
      gap: 8px;
      /* Espacio entre botones */
      margin-top: 0.5rem;
    }

    .contador button {
      padding: 6px 12px;
      background: #ff6f00;
      color: white;
      border: none;
      border-radius: 8px;
      font-size: 1rem;
      cursor: pointer;
      transition: background 0.3s;
    }

    .contador button:hover {
      background: #e65100;
    }

    .contador span {
      font-weight: bold;
      font-size: 1.1rem;
      margin: 0 1rem;
    }

    .carrito {
      position: fixed;
      bottom: 0;
      width: 100%;
      background: #fff3e0;
      padding: 1rem;
      display: flex;
      justify-content: space-between;
      align-items: center;
      box-shadow: 0 -2px 6px rgba(0, 0, 0, 0.08);
      z-index: 1000;
    }

    .total {
      font-weight: bold;
      font-size: 1.2rem;
    }

    .btn-pedido {
      background: linear-gradient(90deg, #ff6f00, #ff9800);
      color: white;
      border-radius: 50px;
      padding: 12px 24px;
      font-size: 1.1rem;
      box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
      transition: all 0.3s;
    }

    .btn-pedido:hover {
      background: linear-gradient(90deg, #2e7d32, #43a047);
      transform: scale(1.08);
    }

    @media (min-width: 768px) {
      .producto {
        flex-direction: row;
        align-items: center;
        height: 160px;
      }

      .producto img {
        width: 160px;
        height: 100%;
      }

      .producto-info {
        flex: 1;
      }
    }

    .badge {
      position: absolute;
      top: 10px;
      left: 10px;
      background: #ff6f00;
      color: white;
      padding: 2px 8px;
      border-radius: 12px;
      font-size: 0.7rem;
      font-weight: bold;
      z-index: 10;
    }

    .btn-top {
      position: fixed;
      bottom: 90px;
      right: 20px;
      background-color: #ff6f00;
      color: white;
      border: none;
      border-radius: 50%;
      width: 50px;
      height: 50px;
      font-size: 22px;
      cursor: pointer;
      z-index: 1000;
      display: none;
      align-items: center;
      justify-content: center;
    }

    .btn-top.show {
      display: flex;
    }

    .swal2-popup {
      font-size: 1rem !important;
    }
  </style>

  <style>
    .btn-filtro {
      padding: 6px 14px;
      border-radius: 20px;
      background: #eee;
      color: #333;
      text-decoration: none;
      font-size: 14px;
      transition: 0.3s;
    }

    .btn-filtro:hover {
      background: #ffcc80;
    }

    .btn-filtro.active {
      background: #ff6f00;
      color: white;
      font-weight: bold;
    }
  </style>
  <style>
    .grid-productos {
      display: grid;
      grid-template-columns: 1fr;
      gap: 1rem;
      margin-bottom: 120px;
      /* Aumenta espacio para evitar que se corte */
    }

    @media (min-width: 600px) {
      .grid-productos {
        grid-template-columns: 1fr 1fr;
      }
    }

    @media (min-width: 1024px) {
      .grid-productos {
        grid-template-columns: 1fr 1fr 1fr 1fr;
      }
    }
  </style>
  <style>
    .whatsapp-float {
      position: fixed;
      bottom: 80px;
      right: 20px;
      background-color: #25d366;
      /* Color de WhatsApp */
      border: 2px solid white;
      /* Borde blanco */
      border-radius: 50%;
      width: 60px;
      height: 60px;
      display: flex;
      justify-content: center;
      align-items: center;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      z-index: 1000;
      cursor: pointer;
      text-decoration: none;
      transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    }

    .whatsapp-float:hover {
      transform: scale(1.1);
      box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
    }

    .whatsapp-float i {
      font-size: 28px;
      /* Tamaño del icono */
      color: white;
    }
  </style>
  <style>
    .icono-info {
      position: absolute;
      top: 8px;
      right: 8px;
      width: 26px;
      height: 26px;
      border-radius: 50%;
      background-color: #ff6f00;
      /* naranja tipo Material */
      color: white;
      font-weight: bold;
      font-size: 18px;
      text-align: center;
      line-height: 26px;
      cursor: pointer;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
      transition: transform 0.2s ease, background-color 0.3s ease;
      z-index: 5;
    }

    .icono-info:hover {
      background-color: #ffcc80;
      transform: scale(1.1);
    }

    </producto animations>.producto {
      position: relative;
    }

    /* Productos al cargar */
    .producto {
      opacity: 0;
      transform: translateY(20px);
      transition: opacity 0.5s ease, transform 0.5s ease;
    }

    .producto.mostrar {
      opacity: 1;
      transform: translateY(0);
    }


    /*<!-- INICIO ANIMA NUMERO AL AGREGAR O QUITAR--> */
    .contador span {
      transition: transform 0.2s ease;
    }

    .contador span.animado {
      transform: scale(1.4);
      color: #ff6f00;
    }

    /*<!-- FIN ANIMA NUMERO AL AGREGAR O QUITAR--> */

    /* Botones de contador rebote */
    .contador button:active {
      transform: scale(0.9);
      transition: transform 0.1s;
    }

    /* Icono vaciar animación */
    #btn-vaciar {
      opacity: 0;
      transform: scale(0.8);
      transition: opacity 0.3s ease, transform 0.3s ease, background 0.3s, border-color 0.3s;
    }

    #btn-vaciar.mostrar {
      opacity: 1;
      transform: scale(1);
    }

    #btn-vaciar:hover {
      background: rgba(255, 111, 0, 0.1);
      border-color: #e65100;
    }

    /* Botón realizar pedido flotante */
    #accion-pedido {
      opacity: 0;
      transform: translateY(50px);
      transition: opacity 0.4s ease, transform 0.4s ease;
    }

    #accion-pedido.mostrar {
      opacity: 1;
      transform: translateY(0);
    }
  </style>
</head>

<body>
  <header>
    <img src="images/logoN<?= $negocio_id ?>.png" alt="Logo">
  </header>

  <div class="slider">
    <div class="slides">
      <img src="images/banner1.jpg" alt="Banner 1">
      <img src="images/banner2.jpg" alt="Banner 2">
      <img src="images/banner5.jpg" alt="Banner 5">
      <img src="images/banner6.jpg" alt="Banner 6">
    </div>
  </div>
  <!--
<div style="padding: 1rem; text-align:center">
  <form method="get" style="margin-bottom: 1rem;">
    <label for="filtro">Filtrar por categoría:</label>
    <select name="filtro" id="filtro" onchange="this.form.submit()">
      <option value="">Todas</option>
      < ?php foreach ($categorias as $cat): ?>
        <option value="<?= $cat ?>" <?= ($cat == $filtro ? 'selected' : '') ?>><?= ucfirst($cat) ?></option>
      < ?php endforeach; ?>
    </select>
  </form>
</div>
      -->

  <div style="padding: 1rem; text-align:center;">
    <div style="padding: 1rem; text-align:center;">
      <input type="text" id="input-busqueda" placeholder="Buscar producto..." style="padding: 8px; border-radius: 6px; border: 1px solid #ccc; width: 250px;">
    </div>

    <div style="flex-wrap: wrap; display: flex; gap: 10px; justify-content: center;">
      <a href="?filtro=" class="btn-filtro<?= !$filtro ? ' active' : '' ?>">Todas</a>
      <?php foreach ($categorias as $cat): ?>
        <a href="?filtro=<?= urlencode($cat) ?>&busqueda=<?= urlencode($busqueda) ?>" class="btn-filtro<?= ($cat == $filtro ? ' active' : '') ?>">
          <?= ucfirst($cat) ?>
        </a>
      <?php endforeach; ?>
    </div>
  </div>


  <?php foreach ($filtrados as $cat => $lista): ?>
    <div class="categoria">
      <h3><?= htmlspecialchars($cat) ?></h3>
      <div class="grid-productos">
        <?php foreach ($lista as $prod): ?>
          <?php
          $stockDisponible = (int) $prod['stock'];
          $permiteSobreventa = (int) $prod['sobreventa'] === 1;
          $puedeVender = $permiteSobreventa || $stockDisponible > 0;
          ?>
          <div class="producto<?= !$puedeVender ? ' agotado' : '' ?>"
            data-id="<?= $prod['id'] ?>"
            data-nombre="<?= htmlspecialchars($prod['nombre']) ?>"
            data-precio="<?= $prod['precio'] ?>"
            data-descripcion="<?= htmlspecialchars($prod['descripcion']) ?>"
            data-imagen="images/productos/<?= $prod['imagen_url'] ?>"
            data-stock="<?= $stockDisponible ?>"
            data-sobreventa="<?= $permiteSobreventa ? '1' : '0' ?>"
            style="border: 1px solid rgb(255, 202, 161);<?= !$puedeVender ? ' opacity:0.5;' : '' ?>">

            <img src="images/productos/<?= $prod['imagen_url'] ?>" onclick="verProducto(this.parentElement)">
            <div class="icono-info" onclick="verProducto(this.parentElement)">!</div>
            <div class="producto-info">
              <div class="nombre"><?= $prod['nombre'] ?></div>
              <div class="precio">$<?= number_format($prod['precio'], 0, ',', '.') ?></div>
              <style>
                .contador button:disabled {
                  background-color: #ccc !important;
                  color: #666 !important;
                  cursor: not-allowed;
                }
              </style>
              <div class="contador">
                <button onclick="sumar(<?= $prod['id'] ?>, -1)">-</button>
                <span id="cantidad-<?= $prod['id'] ?>">0</span>
                <button id="btn-sumar-<?= $prod['id'] ?>" onclick="sumar(<?= $prod['id'] ?>, 1)" <?= !$puedeVender ? 'disabled' : '' ?>>+</button>
              </div>
              <?php if (!empty($prod['Apedido']) && $prod['Apedido'] == 1): ?>
                <div style="font-size: 0.75rem; color: #ff6f00; margin-top: 4px;">
                  A pedido (mín. <?= (int)$prod['hrs_produccion'] ?> hrs)
                </div>
              <?php endif; ?>
            </div>
          </div>
        <?php endforeach; ?>
        <style>
          .producto.agotado {
            opacity: 0.5;
            pointer-events: auto;
          }

          .producto.agotado .contador button {
            opacity: 0.7;
          }

          .producto.agotado .contador button[disabled] {
            cursor: not-allowed;
            background: #ccc;
            color: #888;
          }
        </style>
      </div>
    </div>
  <?php endforeach; ?>

  <div class="formulario" style="display: none;">
    <h4>Tus datos</h4>
    <input type="text" id="nombre" placeholder="Nombre">
    <input type="text" id="direccion" placeholder="Dirección">
    <input type="text" id="telefono" placeholder="Celular">
  </div>

  <div class="carrito d-flex justify-content-between align-items-center flex-wrap gap-2">
    <div class="total fw-bold fs-5 d-flex align-items-center gap-2">
      Total: $<span id="total">0</span>
      <i onclick="vaciarCarrito()" id="btn-vaciar" class="fas fa-trash" style="color: #ff6f00; font-size: 18px; margin-left: 8px; line-height: 1; display: inline-flex; align-items: center; cursor: pointer;"></i>
    </div>
    <button class="btn btn-success btn-pedido" onclick="realizarPedido()" id="btn-pedido">📦 Realizar Pedido</button><!--style="display: none;"-->
  </div>

  <!-- Botón ir arriba -->
  <button onclick="window.scrollTo({ top: 0, behavior: 'smooth' });" id="btnTop" class="btn-top">↑</button>

  <script>
    window.addEventListener('scroll', function() {
      const btnTop = document.getElementById('btnTop');
      if (window.scrollY > 300) {
        btnTop.classList.add('show');
      } else {
        btnTop.classList.remove('show');
      }
    });
  </script>
  <script>
    function vaciarCarrito() {
      carrito = {};
      localStorage.removeItem('carrito');

      // Poner cantidad a 0 en todos los productos visibles
      document.querySelectorAll('[id^="cantidad-"]').forEach(el => {
        el.innerText = '0';
      });

      // Reactivar botón "+" y restaurar stock visual en todos los productos
      document.querySelectorAll('.producto').forEach(prod => {
        const stockEl = prod.querySelector('.stock-disponible');
        const btnSumar = prod.querySelector('.contador button:last-child');
        if (stockEl && btnSumar) {
          btnSumar.disabled = false;
          const originalStock = parseInt(stockEl.dataset.originalStock);
          // stockEl.innerText = 'Stock: ' + originalStock;
        }
      });

      calcularTotal();
    }
  </script>

  <script>
    //const carrito = {};
    let carrito = JSON.parse(localStorage.getItem('carrito')) || {};
    let total = 0;
    window.addEventListener('DOMContentLoaded', () => {
      document.querySelectorAll('.producto').forEach((prod, i) => {
        setTimeout(() => {
          prod.classList.add('mostrar');
        }, i * 100);
      });

      Object.keys(carrito).forEach(id => {
        if (document.getElementById('cantidad-' + id)) {
          document.getElementById('cantidad-' + id).innerText = carrito[id];
        }
      });
      calcularTotal();
    });

    // (Eliminado: versión antigua de sumar)

    function calcularTotal() {
      total = 0;
      document.querySelectorAll('.producto').forEach(p => {
        const id = p.dataset.id;
        const precio = parseInt(p.dataset.precio);
        const cant = carrito[id] || 0;
        total += cant * precio;
      });
      document.getElementById('total').innerText = total.toLocaleString();
      //document.getElementById('btn-pedido').style.display = total > 0 ? 'block' : 'none';

      const contenedorCarrito = document.querySelector('.carrito');
      if (total > 0) {
        contenedorCarrito.style.display = 'flex';
      } else {
        contenedorCarrito.style.display = 'none';
      }

      /*
        const resumenBoton = document.getElementById('btn-pedido');
            if(resumenBoton){
            resumenBoton.onclick = () => {
                if(total > 0){
                let resumen = '';
                Object.keys(carrito).forEach(id => {
                    const prod = document.querySelector('.producto[data-id="'+id+'"]');
                    if(prod){
                    const nombre = prod.dataset.nombre;
                    const cant = carrito[id];
                    resumen += `<p>${nombre} x${cant}</p>`;
                    }
                });

                Swal.fire({
                    title: 'Tu Pedido',
                    html: resumen || 'Sin productos',
                    confirmButtonText: 'Continuar Pedido',
                    showCloseButton: true
                }).then(result => {
                    if(result.isConfirmed){
                    realizarPedido();
                    }
                });
                }
            };
            }
        */
      const btnVaciar = document.getElementById('btn-vaciar');
      if (total > 0) {
        btnVaciar.classList.add('mostrar');
      } else {
        btnVaciar.classList.remove('mostrar');
      }

      const accionPedido = document.getElementById('accion-pedido');
      if (accionPedido) {
        if (total > 0) {
          accionPedido.classList.add('mostrar');
        } else {
          accionPedido.classList.remove('mostrar');
        }
      }
    }

    function realizarPedido() {
      let total = 0;
      let items = [];

      document.querySelectorAll('.producto').forEach(prod => {
        const id = parseInt(prod.dataset.id);
        const nombre = prod.dataset.nombre;
        const precio = parseInt(prod.dataset.precio);
        const cantidad = carrito[id] || 0;

        if (cantidad > 0) {
          items.push({
            id,
            nombre,
            precio,
            cantidad
          });
          total += precio * cantidad;

        }
      });

      if (items.length === 0) {
        Swal.fire('Carrito vacío', 'Agrega productos al carrito antes de continuar.', 'warning');
        return;
      }

      // Redirigir a checkout.php con los datos
      const form = document.createElement('form');
      form.method = 'POST';
      form.action = 'admin/checkout.php';

      const input1 = document.createElement('input');
      input1.type = 'hidden';
      input1.name = 'carrito';
      input1.value = JSON.stringify(items);
      form.appendChild(input1);

      const input2 = document.createElement('input');
      input2.type = 'hidden';
      input2.name = 'total';
      input2.value = total;
      form.appendChild(input2);

      const inputNegocio = document.createElement('input');
      inputNegocio.type = 'hidden';
      inputNegocio.name = 'negocio_id';
      inputNegocio.value = <?= $negocio_id ?>;
      form.appendChild(inputNegocio);

      document.body.appendChild(form);
      form.submit();
    }
  </script>

  <script>
    document.getElementById('input-busqueda').addEventListener('input', function() {
      const texto = this.value.toLowerCase();

      document.querySelectorAll('.producto').forEach(prod => {
        const nombre = prod.dataset.nombre.toLowerCase();
        prod.style.display = nombre.includes(texto) ? '' : 'none';
      });

      // Ocultar categorías si no tienen productos visibles
      document.querySelectorAll('.categoria').forEach(categoria => {
        const visibles = categoria.querySelectorAll('.producto:not([style*="display: none"])');
        categoria.style.display = visibles.length ? '' : 'none';
      });
    });
  </script>
  <script>
    window.addEventListener('scroll', function() {
      const header = document.querySelector('header');
      if (window.scrollY > 50) {
        header.classList.add('header-small');
      } else {
        header.classList.remove('header-small');
      }
    });
  </script>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    function verProducto(elemento) {
      const id = elemento.dataset.id;
      const nombre = elemento.dataset.nombre;
      const descripcion = elemento.dataset.descripcion || '';
      const precio = parseFloat(elemento.dataset.precio);
      const imagen = elemento.dataset.imagen;
      const cantidad = document.getElementById('cantidad-' + id).innerText;

      Swal.fire({
        html: `
  <div style="background:#fff; border-radius:16px; box-shadow:0 6px 20px rgba(0,0,0,0.1); padding:1rem; text-align:center; font-family:'Poppins', sans-serif;">
    <img src="${imagen}" style="width:100%; border-radius:12px; margin-bottom:12px; object-fit:cover; height:160px;">
    <p style="font-weight:600; font-size:1.1rem; margin: 0 0 8px;">${nombre}</p>
    <p style="color:#666; margin:0 0 12px;">${descripcion}</p>
    <p style="font-size:1rem; color:#333; font-weight:bold; margin:0 0 16px;">Precio: $${precio.toLocaleString('es-CL')}</p>
    <div style="display:flex; justify-content:center; align-items:center; gap:10px;">
      <button onclick="sumar(${id}, -1); Swal.getPopup().querySelector('#swal-cantidad').innerText = document.getElementById('cantidad-${id}').innerText;" style="padding: 6px 12px; background: #ff6f00; color: white; border: none; border-radius: 8px; font-size: 1rem;">-</button>
      <span id="swal-cantidad" style="font-weight: bold; font-size: 1.1rem;">${cantidad}</span>
      <button onclick="sumar(${id}, 1); Swal.getPopup().querySelector('#swal-cantidad').innerText = document.getElementById('cantidad-${id}').innerText;" style="padding: 6px 12px; background: #ff6f00; color: white; border: none; border-radius: 8px; font-size: 1rem;">+</button>
    </div>
  </div>
`,
        showCloseButton: true,
        showConfirmButton: false,
        width: 400
      });
    }
  </script>

  <!-- INICIO ANIMA NUMERO AL AGREGAR O QUITAR-->
  <script>
    function sumar(id, cambio) {
      const prodElem = document.querySelector('.producto[data-id="' + id + '"]');
      const permiteSobreventa = prodElem?.dataset.sobreventa === "1";
      const originalStock = parseInt(prodElem?.dataset.stock || "0");

      let nuevaCantidad = (carrito[id] || 0) + cambio;
      if (nuevaCantidad < 0) nuevaCantidad = 0;

      if (!permiteSobreventa && nuevaCantidad > originalStock) {
        return;
      }

      carrito[id] = nuevaCantidad;
      localStorage.setItem('carrito', JSON.stringify(carrito));

      const spanCantidad = document.getElementById('cantidad-' + id);
      if (spanCantidad) {
        spanCantidad.innerText = nuevaCantidad;
        spanCantidad.classList.add('animado');
        setTimeout(() => {
          spanCantidad.classList.remove('animado');
        }, 200);
      }

      const btnSumar = document.getElementById('btn-sumar-' + id);
      if (btnSumar) {
        btnSumar.disabled = !permiteSobreventa && nuevaCantidad >= originalStock;
      }

      calcularTotal();
    }
  </script>
  <!-- FIN ANIMA NUMERO AL AGREGAR O QUITAR-->


  <!-- Enlace a Font Awesome para los iconos -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

  <!-- Botón flotante de WhatsApp -->
  <!--<a href="https://wa.me/+56986317508?text=Hola,%20necesito%20más%20información." target="_blank" class="whatsapp-float" aria-label="Contactar por WhatsApp">
  <i class="fab fa-whatsapp"></i>
</a>-->


</body>

</html>