<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once '/var/www/html/vendor/autoload.php';

function enviarCorreoEstado($email, $nombre, $estado, $pedido_id, $logoUrl)
{
  if (!filter_var($email, FILTER_VALIDATE_EMAIL)) return;

  $mail = new PHPMailer(true);
  $mail->CharSet = 'UTF-8';

  try {
    $mail->isSMTP();
    $mail->Host       = 'smtp.gmail.com';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'ddulcesysaladas@gmail.com';
    $mail->Password   = 'ptuy zwnj mowb hhlc';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = 587;

    $mail->setFrom('ddulcesysaladas@gmail.com', 'Delicias Dulces y Saladas');
    $mail->addAddress($email, $nombre);

    $mail->isHTML(true);
    $mail->Subject = "📦 Estado actualizado - Pedido #$pedido_id";

    // Mensaje personalizado por estado
    $mensajeEstado = match (strtolower($estado)) {
      'pendiente'     => 'Hemos recibido tu pedido y está pendiente de confirmación.',
      'confirmado'    => 'Tu pedido ha sido confirmado. ¡Gracias por confiar en nosotros!',
      'preparando'    => 'Estamos preparando tu pedido con cariño en nuestra cocina.',
      'preparado'     => 'Tu pedido ya está preparado y listo para ser despachado o retirado.',
      'listoretiro'   => 'Tu pedido está listo para retiro. ¡Puedes venir por él cuando gustes!',
      'despachado'    => 'Tu pedido ha sido despachado. Pronto estará contigo.',
      'en camino'     => '¡Tu pedido está en camino! 🚚',
      'entregado'     => 'Tu pedido ha sido entregado. ¡Esperamos que lo disfrutes!',
      'cancelado'     => 'Tu pedido ha sido cancelado. Si tienes dudas, contáctanos.',
      default         => 'Tu pedido ha cambiado de estado.',
    };

    $mail->Body = '
        <div style="font-family: Poppins, sans-serif; max-width: 600px; margin: auto; padding: 1.5rem; background: #fffefb; border-radius: 10px;">
          <div style="text-align: center;">
            <img src="http://168.232.165.4/Pedidos_Saas/images/' . htmlspecialchars($logoUrl) . '" alt="Logo" style="max-height: 60px;">
            <h2 style="color: #ff6f00;">Hola ' . htmlspecialchars($nombre) . '</h2>
            <p style="font-size: 16px;">' . $mensajeEstado . '</p>
            <p>Estado actual: <strong style="color:#ff6f00;">' . strtoupper($estado) . '</strong></p>
          </div>
          <p style="text-align: center; font-size: 0.8rem; color: #aaa;">Delicias Dulces y Saladas</p>
        </div>';

    $mail->send();
  } catch (Exception $e) {
    error_log("Error al enviar correo de estado: {$mail->ErrorInfo}");
  }
}
